--[[
	WrappedBaleCounter.lua
	
	Autor: 		Ifko[nator]
	Datum: 		21.04.2022
	Version: 	2.1
	
	Changelog:	v1.0 @26.12.2018 - initial implementation in FS 19
				--------------------------------------------------
				v2.0 @18.11.2021 - convert to FS 22
				--------------------------------------------------
				v2.1 @21.04.2022 - fix for patch 1.4 and higher
]]

WrappedBaleCounter = {};
WrappedBaleCounter.currentModName = "";

for _, mod in pairs(g_modManager.mods) do
	if mod.title == "Bale Counter" or mod.title == "Ballenzähler" or mod.title == "Compteur de balles pressées" then		
		if g_modIsLoaded[tostring(mod.modName)] then	
			WrappedBaleCounter.currentModName = mod.modName;
			
			break;
		end;
	end;
end;

function WrappedBaleCounter.initSpecialization()
	local schemaSavegame = Vehicle.xmlSchemaSavegame;

	schemaSavegame:register(XMLValueType.INT, "vehicles.vehicle(?).wrappedBaleCounter#countToday", "Bales wrapped on field.", 0);
	schemaSavegame:register(XMLValueType.INT, "vehicles.vehicle(?).wrappedBaleCounter#countTotal", "Bales wrapped total.", 0);
end;

function WrappedBaleCounter.prerequisitesPresent(specializations)
	return SpecializationUtil.hasSpecialization(BaleWrapper, specializations);
end;

function WrappedBaleCounter.registerEventListeners(vehicleType)
	local functionNames = {
		"onLoad",
		"saveToXMLFile",
		"onUpdate",
		"onRegisterActionEvents",
		"onWriteStream",
		"onReadStream"
	};
	
	for _, functionName in ipairs(functionNames) do
		SpecializationUtil.registerEventListener(vehicleType, functionName, WrappedBaleCounter);
	end;
end;

function WrappedBaleCounter.registerFunctions(vehicleType)
	local newFunctions = {
		"setWrappedBaleCounterToZero"
	};
	
	for _, newFunction in ipairs(newFunctions) do
		SpecializationUtil.registerFunction(vehicleType, newFunction, WrappedBaleCounter[newFunction]);
	end;
end;

function WrappedBaleCounter:onLoad(savegame)
	local specWrappedBaleCounter = self.spec_wrappedBaleCounter;
	
	if savegame ~= nil then
		specWrappedBaleCounter.countToday = savegame.xmlFile:getValue(savegame.key .. ".wrappedBaleCounter#countToday", 0);
		specWrappedBaleCounter.countTotal = savegame.xmlFile:getValue(savegame.key .. ".wrappedBaleCounter#countTotal", 0);
	else
		specWrappedBaleCounter.countToday = 0;
		specWrappedBaleCounter.countTotal = 0;
	end;
	
	specWrappedBaleCounter.hasCountedWrappedBale = false;
	specWrappedBaleCounter.baleWasWrapped = false;

	specWrappedBaleCounter.l10NTexts = {};

	local l10NTexts = {
		"WRAPPED",
		"BALES_TODAY",
		"BALES_TOTAL",
		"input_RESET_WRAPPED_BALE_COUNT_DAY_BUTTON"
	};

	for _, l10NText in pairs(l10NTexts) do
		specWrappedBaleCounter.l10NTexts[l10NText] = g_i18n:getText(l10NText, WrappedBaleCounter.modName);
	end;
end;

function WrappedBaleCounter:onRegisterActionEvents(isActiveForInput)
	if self.isClient then
        local specWrappedBaleCounter = self.spec_wrappedBaleCounter;
        
		self:clearActionEventsTable(specWrappedBaleCounter.actionEvents);
        
		if self:getIsActiveForInput(true, false) then
			local _, actionEventId = self:addActionEvent(specWrappedBaleCounter.actionEvents, InputAction.RESET_WRAPPED_BALE_COUNT_DAY_BUTTON, self, WrappedBaleCounter.actionEventResetBaleCountDay, false, true, false, true, nil);

			g_inputBinding:setActionEventTextPriority(actionEventId, GS_PRIO_HIGH);
			g_inputBinding:setActionEventTextVisibility(actionEventId, specWrappedBaleCounter.countToday > 0);
			g_inputBinding:setActionEventActive(actionEventId, specWrappedBaleCounter.countToday > 0);
		end;
	end;
end;

function WrappedBaleCounter.actionEventResetBaleCountDay(self, actionName, inputValue, callbackState, isAnalog)
	local specWrappedBaleCounter = self.spec_wrappedBaleCounter;
	
	self:setWrappedBaleCounterToZero(0);
end;

function WrappedBaleCounter:setWrappedBaleCounterToZero(countToday, noEventSend)
	local specWrappedBaleCounter = self.spec_wrappedBaleCounter;
	
	if countToday ~= specWrappedBaleCounter.countToday then
		if not noEventSend then
			if g_server ~= nil then
				g_server:broadcastEvent(WrappedBaleCounterEvent.new(self, countToday), nil, nil, self);
			else
				g_client:getServerConnection():sendEvent(WrappedBaleCounterEvent.new(self, countToday));
			end;
		end;
		
		specWrappedBaleCounter.countToday = countToday;
	end;
end;

function WrappedBaleCounter:onWriteStream(streamId, connection)
    if not connection:getIsServer() then 
		local specWrappedBaleCounter = self.spec_wrappedBaleCounter;
		
		streamWriteInt32(streamId, specWrappedBaleCounter.countToday);
		streamWriteInt32(streamId, specWrappedBaleCounter.countTotal);
	end;
end;

function WrappedBaleCounter:onReadStream(streamId, connection)
    if connection:getIsServer() then
		local specWrappedBaleCounter = self.spec_wrappedBaleCounter;
		
		specWrappedBaleCounter.countToday = streamReadInt32(streamId);
		specWrappedBaleCounter.countTotal = streamReadInt32(streamId);
	end;
end;

function WrappedBaleCounter:onUpdate(dt, isActiveForInput, isActiveForInputIngnoreSelection, isSelected)
	local specWrappedBaleCounter = self.spec_wrappedBaleCounter;
	local specBaleWrapper = self.spec_baleWrapper;
	
	if specBaleWrapper.baleWrapperState == BaleWrapper.STATE_WRAPPER_WRAPPING_BALE then
		specWrappedBaleCounter.baleWasWrapped = true;
	end;
	
	if specBaleWrapper.baleWrapperState == BaleWrapper.CHANGE_WRAPPER_BALE_DROPPED then
		if specWrappedBaleCounter.baleWasWrapped and not specWrappedBaleCounter.hasCountedWrappedBale then
			specWrappedBaleCounter.countToday = specWrappedBaleCounter.countToday + 1;
			specWrappedBaleCounter.countTotal = specWrappedBaleCounter.countTotal + 1;
			
			specWrappedBaleCounter.hasCountedWrappedBale = true;
			specWrappedBaleCounter.baleWasWrapped = false;
		end;
	else
		specWrappedBaleCounter.hasCountedWrappedBale = false;
	end;

	if self:getIsActiveForInput(true, false) then
		g_currentMission:addExtraPrintText(specWrappedBaleCounter.l10NTexts.WRAPPED .. " " .. specWrappedBaleCounter.l10NTexts.BALES_TODAY .. ": " .. specWrappedBaleCounter.countToday .. " | " .. specWrappedBaleCounter.l10NTexts.BALES_TOTAL .. ": " .. specWrappedBaleCounter.countTotal);

		local resetWrappedBaleCountDayButton = specWrappedBaleCounter.actionEvents[InputAction.RESET_WRAPPED_BALE_COUNT_DAY_BUTTON];
	
		if resetWrappedBaleCountDayButton ~= nil then
			g_inputBinding:setActionEventActive(resetWrappedBaleCountDayButton.actionEventId, specWrappedBaleCounter.countToday > 0);
			g_inputBinding:setActionEventTextVisibility(resetWrappedBaleCountDayButton.actionEventId, specWrappedBaleCounter.countToday > 0);
			g_inputBinding:setActionEventText(resetWrappedBaleCountDayButton.actionEventId, specWrappedBaleCounter.l10NTexts.input_RESET_WRAPPED_BALE_COUNT_DAY_BUTTON);
		end;
	end;
end;

function WrappedBaleCounter:saveToXMLFile(xmlFile, key)
	local specWrappedBaleCounter = self.spec_wrappedBaleCounter;
	
	xmlFile:setValue(key .. "#countToday", specWrappedBaleCounter.countToday);
	xmlFile:setValue(key .. "#countTotal", specWrappedBaleCounter.countTotal);
end;

WrappedBaleCounterEvent = {};
WrappedBaleCounterEvent_mt = Class(WrappedBaleCounterEvent, Event);

InitEventClass(WrappedBaleCounterEvent, "WrappedBaleCounterEvent");

function WrappedBaleCounterEvent.emptyNew()
	local self = Event.new(WrappedBaleCounterEvent_mt);
    
	return self;
end;

function WrappedBaleCounterEvent.new(baleWrapper, countToday)
	local self = WrappedBaleCounterEvent.emptyNew();
	
	self.baleWrapper = baleWrapper;
	self.countToday = countToday;
	
	return self;
end;

function WrappedBaleCounterEvent:readStream(streamId, connection)
	self.baleWrapper = NetworkUtil.readNodeObject(streamId);
	self.countToday = streamReadInt32(streamId);
    
	self:run(connection);
end;

function WrappedBaleCounterEvent:writeStream(streamId, connection)
	NetworkUtil.writeNodeObject(streamId, self.baleWrapper);
	streamWriteInt32(streamId, self.countToday);
end;

function WrappedBaleCounterEvent:run(connection)
	if not connection:getIsServer() then
		g_server:broadcastEvent(WrappedBaleCounterEvent.new(self.baleWrapper, self.countToday), nil, connection, self.baleWrapper);
	end;
	
    if self.baleWrapper ~= nil then
        self.baleWrapper:setWrappedBaleCounterToZero(self.countToday, true);
	end;
end;