-- a lot of stuff that barely works.. the entire production and selling station system isn't exactly easy to attach to 

-- by modelleicher (Farming Agency)
-- rework and addon for Production Revamp by braeven
-- addon for Pump'n Hoses by Braeven - 13.10.2022


addToProductionAndSellingStation = {}

addModEventListener(addToProductionAndSellingStation);

addToProductionAndSellingStation.modDirectory = g_currentModDirectory


-- add XML Schema
g_xmlManager:addCreateSchemaFunction(function ()
	addToProductionAndSellingStation.xmlSchema = XMLSchema.new("addToProductionAndSellingStation")
end)

--Add new XML-Path for ProductionPoint Related stuff
function addToProductionAndSellingStation.registerXMLPaths(schema, basePath)
  schema:register(XMLValueType.STRING, basePath .. ".productions.production(?).inputs.input(?)#mix", "Mixing Group for Input", 0)
  schema:register(XMLValueType.FLOAT, basePath .. ".productions.production(?).inputs.input(?)#boostfactor", "Boost-Factor for Input", 0)
  schema:register(XMLValueType.FLOAT, basePath .. ".productions#maizeplus", "If a production is used with this script", true)
end

ProductionPoint.registerXMLPaths = Utils.prependedFunction(ProductionPoint.registerXMLPaths, addToProductionAndSellingStation.registerXMLPaths)

-- register XML Schema and load data from maizePlus_bunkerSilo.xml
function addToProductionAndSellingStation:loadMap(n)
  local schema = addToProductionAndSellingStation.xmlSchema

  local sellingStationPath = "addToProductionAndSellingStation.sellingStation(?)"

  schema:register(XMLValueType.STRING, sellingStationPath .. "#attachTo", "Which FillType to use as guide to attach to", nil)
  schema:register(XMLValueType.STRING, sellingStationPath .. "#fillType", "New FillType to be added", nil)
  schema:register(XMLValueType.FLOAT, sellingStationPath .. "#priceScale", "PriceScale of new fillType", 1)
  schema:register(XMLValueType.BOOL, sellingStationPath .. "#supportsGreatDemand", "supportsGreatDemand Boolean of new fillType", false)
  schema:register(XMLValueType.BOOL, sellingStationPath .. "#disablePriceDrop", "disablePriceDrop Boolean of new fillType", false)

  local productionPath = "addToProductionAndSellingStation.production(?)"
  schema:register(XMLValueType.STRING, productionPath .. "#attachTo", "Which Input FillType to use as guide to attach to", nil)
  schema:register(XMLValueType.STRING, productionPath .. "#requiredOutput", "Which Output FillType is needed to use as guide to attach to", nil)
  schema:register(XMLValueType.BOOL, productionPath .. "#revamp", "Recipe is only to be used with Production Revamp", false)
  schema:register(XMLValueType.STRING, productionPath .. "#id", "Save ID for Production", nil)
  schema:register(XMLValueType.STRING, productionPath .. "#name", "Name of Production FillType", nil)
  schema:register(XMLValueType.FLOAT, productionPath .. "#cyclesPerHourScale", "Cycles Per Hour", 1)
  schema:register(XMLValueType.FLOAT, productionPath .. "#costsPerActiveHourScale", "Cost per Active Hour", 1)

  schema:register(XMLValueType.STRING, productionPath .. ".inputs.input(?)#fillType", "Input FillType", nil)
  schema:register(XMLValueType.FLOAT, productionPath .. ".inputs.input(?)#amountScale", "Input Amount Scale", 1)

  schema:register(XMLValueType.STRING, productionPath .. ".outputs.output(?)#fillType", "Output FillType", nil)
  schema:register(XMLValueType.FLOAT, productionPath .. ".outputs.output(?)#amountScale", "Output Amount Scale", 1)


  local xml = XMLFile.load("addToProductionAndSellingStationXMLFile", addToProductionAndSellingStation.modDirectory.."xml/maizePlus_addToProductionAndSellingStation.xml", addToProductionAndSellingStation.xmlSchema)

  addToProductionAndSellingStation.sellingStations = {}
  addToProductionAndSellingStation.sellingStationsIndicesByAttachTo = {}
  local index = 0
  while true do
    local sellingStation = {}
    local path = "addToProductionAndSellingStation.sellingStation("..index..")"

    local attachTo = xml:getValue(path.."#attachTo")
    if attachTo == nil then
      break
    end
    attachTo = g_fillTypeManager:getFillTypeIndexByName(attachTo)
    if attachTo == nil then
      break
    end

    sellingStation.attachTo = attachTo
    sellingStation.fillType = xml:getValue(path.."#fillType")
    sellingStation.priceScale = xml:getValue(path.."#priceScale")
    sellingStation.supportsGreatDemand = xml:getValue(path.."#supportsGreatDemand")
    sellingStation.disablePriceDrop = xml:getValue(path.."#disablePriceDrop")

    index = index +1
    addToProductionAndSellingStation.sellingStations[index] = sellingStation

    if addToProductionAndSellingStation.sellingStationsIndicesByAttachTo[attachTo] == nil then
      addToProductionAndSellingStation.sellingStationsIndicesByAttachTo[attachTo] = {}
    end
    table.insert(addToProductionAndSellingStation.sellingStationsIndicesByAttachTo[attachTo], index )
  end


  addToProductionAndSellingStation.productions = {}    
  addToProductionAndSellingStation.productionsIndicesByAttachTo = {}
  index = 0

  --Production Revamp: Test if Revamp is available
  local mods = g_modManager:getActiveMods(FS22_A_ProductionRevamp)
  local ProductionRevamp = false
  
  for index, activemod in pairs(mods) do
    ProductionRevamp = true
  end
  
  while true do
    local production = {}
    local path = "addToProductionAndSellingStation.production("..index..")"

    local attachTo = xml:getValue(path.."#attachTo")
    if attachTo == nil then
      break
    end
    attachTo = g_fillTypeManager:getFillTypeIndexByName(attachTo)
    if attachTo == nil then
      break
    end

    local requiredOutput = xml:getValue(path.."#requiredOutput")
    if requiredOutput == nil then
      break
    end
    requiredOutput = g_fillTypeManager:getFillTypeIndexByName(requiredOutput)
    if requiredOutput == nil then
      break
    end

    production.attachTo = attachTo
    production.requiredOutput = requiredOutput
    
    --Production Revamp: Check if a recipe is for Production Revamp
    local revamp = xml:getValue(path.."#revamp", false)
    if revamp == nil or revamp == false then
      production.revamp = false
    else
      production.revamp = true
    end

    --Production Revamp: Only load recipes for Production Revamp, if the mod is active
    local skip = false
    if production.revamp == true then
      if ProductionRevamp == false then
        break
      end
    end
    
    if skip == false then
      production.id = xml:getValue(path.."#id")
      production.name = getXMLString(xml.handle, path.."#name")
      production.cyclesPerHourScale = xml:getValue(path.."#cyclesPerHourScale")
      production.costsPerActiveHourScale = xml:getValue(path.."#costsPerActiveHourScale")

      production.inputs = {}
      local inputIndex = 0
      while true do
        local input = {}

        input.type = g_fillTypeManager:getFillTypeIndexByName(xml:getValue(path..".inputs.input("..inputIndex..")#fillType"))
        if input.type == nil or input.type == "" then
          break
        end
        input.amountScale = xml:getValue(path..".inputs.input("..inputIndex..")#amountScale")
        table.insert(production.inputs, input)
        inputIndex = inputIndex +1
      end

      production.outputs = {}
      local outputIndex = 0
      while true do
        local output = {}

        output.type = g_fillTypeManager:getFillTypeIndexByName(xml:getValue(path..".outputs.output("..outputIndex..")#fillType"))
        if output.type == nil or output.type == "" then
          break
        end
        output.amountScale = xml:getValue(path..".outputs.output("..outputIndex..")#amountScale")

        outputIndex = outputIndex +1
        production.outputs[outputIndex] = output
      end

      index = index +1
      addToProductionAndSellingStation.productions[index] = production

      if addToProductionAndSellingStation.productionsIndicesByAttachTo[attachTo] == nil then
        addToProductionAndSellingStation.productionsIndicesByAttachTo[attachTo] = {}
      end
      table.insert(addToProductionAndSellingStation.productionsIndicesByAttachTo[attachTo], index )
    end
  end
end

-- alter XML file before ProductionPoint.load to inject additional productions
function addToProductionAndSellingStation.load(self, superFunc, components, xmlFile, key, customEnv, i3dMappings)
  local ref = addToProductionAndSellingStation

  local numberOfProductions = 0
  --iterate through all productions in this XML to find number of productions
  --this means we iterate twice but since there are multiple attachTo possibilities so I need to add productions mid-iteration I need to know the # beforehand, not sure if there is another way
  xmlFile:iterate(key .. ".productions.production", function (index, productionKey)
    numberOfProductions = numberOfProductions +1
  end)

  --second iteration
  local attached = {}
  local storages = {}
  xmlFile:iterate(key .. ".productions.production", function (index1, productionKey)
    --skip if the flag maizeplus is false
    local skipProduction = xmlFile:getValue(key .. ".productions#maizeplus", true)
    
    --iterate through all inputs
    xmlFile:iterate(productionKey .. ".inputs.input", function (inputIndex, inputKey)

      --check if input exists in our attachTo table and check if not already attached for this production
      local input = g_fillTypeManager:getFillTypeIndexByName(xmlFile:getValue(inputKey .. "#fillType"))
      if ref.productionsIndicesByAttachTo[input] ~= nil and attached[input] == nil then

        --add all our productions
        for i = 1, #ref.productionsIndicesByAttachTo[input] do
          --get - table of productions from our xml
          local get = ref.productions[ref.productionsIndicesByAttachTo[input][i]]

          --check if requiredOutput is avaible and input is not output
          local skip = true
          local skip2 = false
          xmlFile:iterate(productionKey .. ".outputs.output", function (outputIndex, outputKey)
            local output = g_fillTypeManager:getFillTypeIndexByName(xmlFile:getValue(outputKey .. "#fillType"))
            if output == input then
              skip2 = true
            elseif output == get.requiredOutput then
              skip = false
            end
          end)

          --check if one of the new inputs is already used in a recipe in this production, this will prevent productions made for maize+ to be altered
          --first we make a list of our new inputs
          local newFillTypes = {}
          for _, newFill in pairs(get.inputs) do
            newFillTypes[newFill.type] = true
          end
          
          --next we look into the storage, if a new filltype can be found in storage, skip
          xmlFile:iterate(key..".storage.capacity", function(storageIndex, storageKey)
            local storageType = g_fillTypeManager:getFillTypeIndexByName(xmlFile:getValue(storageKey .. "#fillType"))
            if newFillTypes[storageType] ~= nil then
              skipProduction = true
            end
          end)
          
          --only attach productionlines if required output is avaible, input is not used as an output and doesn't contain recipes with the new fillTypes
          if skip == false and skip2 == false and skipProduction == true then

            --path for the new production
            local path = key..".productions.production("..numberOfProductions..")"
            local rIndex = -1
            local mix = 0

            --Production Revamp: Check if this recipe is using Revamp, get the number of inputs for this recipe and get the number of mix-groups
            local revampMix = {}
            xmlFile:iterate(productionKey .. ".inputs.input", function (rInputIndex, rInputKey)
              local rMix = xmlFile:getValue(rInputKey .. "#mix", 0)
              if rMix == "boost" then
                rMix = 6
              elseif rMix == "master" then
                rMix = 7
              else
                rMix = tonumber(rMix)
              end
              if rMix ~= 0 and get.revamp == false then
                --Production Revamp: Skip attachTo-recipes for productions that use Revamp, if the recipe isn't made for revamp
                skip = true
              else
                revampMix[rMix] = true
              end
              rIndex = rIndex + 1
            end)

            --Production Revamp: Count mix-groups
            local rCount = 0
              for _, _ in pairs(revampMix) do
              rCount = rCount + 1
            end
            
            --Production Revamp: Only run Revamp-recipes with Revamp productions
            if get.revamp == true and rCount == 1 then
              skip = true
            elseif get.revamp == true then

              --Production Revamp: If Production Revamp is present and used, the mix-attribute could be available for the input
              local rMix = xmlFile:getValue(inputKey .. "#mix", 0)
              if rMix == nil or rMix == "" then
                mix = 0
              elseif rMix == "boost" then
                mix = 6
                local boostFactor = xmlFile:getValue(inputKey .. "#boostfactor")
              else
                mix = tonumber(rMix)
              end

              --Production Revamp: Find a free Mix-number if attachTo doesn't have a mix assigned
              if mix == 0 then
                if revampMix[1] == nil then
                  mix = 1
                elseif revampMix[2] == nil then
                  mix = 2
                elseif revampMix[3] == nil then
                  mix = 3
                elseif revampMix[4] == nil then
                  mix = 4
                elseif revampMix[5] == nil then
                  mix = 5
                end

                --Production Revamp: Set Mix for the attachTo-Filltype if one was choosen
                if mix ~= 0 then
                  xmlFile:setInt(productionKey..".inputs.input("..(inputIndex-1)..")#mix", mix)
                end
              end
              path = key..".productions.production("..(index1 -1)..")"

            --Production Revamp: Skip this recipe if there still is no mix
              if mix == 0 then
                skip = true
              end
              
            --Production Revamp: Skip this recipe if mix groups have been found and Revamp isn't present
            elseif rCount > 1 then
              skip = true
            end

            if skip == false then
              --Production Revamp: Run this part only if Production Revamp isn't used
              if get.revamp == false then
                --set XML Values base
                setXMLString(xmlFile.handle, path.."#id", get.id)
                setXMLString(xmlFile.handle, path.."#name", get.name)

                --get cycles per hour and month via getFloat so it returns nil if not exists, get cyclesPerMonth as getValue as fallback in case it doesn't exist in XML
                local cyclesPerHour = xmlFile:getFloat(productionKey .. "#cyclesPerHour")
                local cyclesPerMinute = xmlFile:getFloat(productionKey .. "#cyclesPerMinute")
                local cyclesPerMonth = xmlFile:getValue(productionKey .. "#cyclesPerMonth")

                --calculate down to cyclesPerHour in case it is nil and use that
                if cyclesPerHour == nil then
                  if cyclesPerMinute ~= nil then
                    cyclesPerHour = cyclesPerMinute * 60
                  else
                    cyclesPerHour = cyclesPerMonth / 30 / 24
                  end
                end

                --same as above but with costs
                local costsPerActiveHour = xmlFile:getFloat(productionKey .. "#costsPerActiveHour")
                local costsPerActiveMinute = xmlFile:getFloat(productionKey .. "#costsPerActiveMinute")
                local costsPerActiveMonth = xmlFile:getValue(productionKey .. "#costsPerActiveMonth")  

                --same as above
                if costsPerActiveHour == nil then
                  if costsPerActiveMinute ~= nil then
                    costsPerActiveHour = costsPerActiveMinute * 60
                  else
                    costsPerActiveHour = costsPerActiveMonth / 30 / 24
                  end
                end

                --finally set cycles and cost per HOUR
                xmlFile:setValue(path.."#cyclesPerHour", cyclesPerHour * get.cyclesPerHourScale)
                xmlFile:setValue(path.."#costsPerActiveHour", costsPerActiveHour * get.costsPerActiveHourScale)
              end

              --add new fillTypes to Storage and get a list of all available storages
              --iterate through all capacities to find # and find storage-size for attachTo
              local numberOfCapacities = -1
              local storageSize = 100000
              xmlFile:iterate(key..".storage.capacity", function(storageIndex, storageKey)
                numberOfCapacities = numberOfCapacities +1
                local storageType = g_fillTypeManager:getFillTypeIndexByName(xmlFile:getValue(storageKey .. "#fillType"))
                storages[storageType] = true
                if input == storageType then
                  storageSize = xmlFile:getValue(storageKey .. "#capacity")
                end
              end)

              --add new inputs and make unloadFillTypeList for later use
              local unloadFillTypeList = ""
              for index, getInput in pairs(get.inputs) do
                if get.revamp == false then
                  --since XML index is 0-based we need -1 off the index, get original amount value and scale via our scaleValue
                  xmlFile:setValue(path..".inputs.input("..(index-1)..")#fillType", g_fillTypeManager:getFillTypeNameByIndex(getInput.type))
                  xmlFile:setValue(path..".inputs.input("..(index-1)..")#amount", xmlFile:getValue(inputKey.."#amount", 1) * getInput.amountScale)
                else
                  --Production Revamp: add FillTypes into existing recipes instead of making new productions
                  xmlFile:setValue(path..".inputs.input("..(rIndex+index)..")#fillType", g_fillTypeManager:getFillTypeNameByIndex(getInput.type))
                  xmlFile:setValue(path..".inputs.input("..(rIndex+index)..")#amount", xmlFile:getValue(inputKey.."#amount", 1) * getInput.amountScale)
                  xmlFile:setInt(path..".inputs.input("..(rIndex+index)..")#mix", mix)
                  if boostFactor ~= nil then
                    xmlFile:setValue(path..".inputs.input("..(rIndex+index)..")#boostfactor", boostFactor)
                  end
                end
                if storages[getInput] == nil then
                  unloadFillTypeList = unloadFillTypeList .." ".. g_fillTypeManager:getFillTypeNameByIndex(getInput.type)  
                end
              end

              --Production Revamp: Run this part only if Production Revamp isn't used
              if get.revamp == false then
              
                local outputNumber = 0
                --iterate through all outputs, we need to find the matching fillType
                xmlFile:iterate(productionKey .. ".outputs.output", function (outputIndex, outputKey)

                  --go through our outputs
                  for index, getOutput in pairs(get.outputs) do

                    --found a match
                    if xmlFile:getValue(outputKey.."#fillType") == g_fillTypeManager:getFillTypeNameByIndex(getOutput.type) then

                      --set values
                      xmlFile:setValue(path..".outputs.output("..(outputNumber)..")#fillType", g_fillTypeManager:getFillTypeNameByIndex(getOutput.type))
                      xmlFile:setValue(path..".outputs.output("..(outputNumber)..")#amount",  xmlFile:getValue(outputKey.."#amount") * getOutput.amountScale)

                      --sellDirectly is only set, if there isn't a storage already
                      if storages[getOutput.type] == nil then
                        xmlFile:setValue(path..".outputs.output("..(outputNumber)..")#sellDirectly", true)
                      end
                      outputNumber = outputNumber + 1
                    end
                  end
                end)
              end

              --add storage space for new fillTypes, if not present
              xmlFile:iterate(key..".storage.capacity", function(_, capacityKey)
                if getXMLString(xmlFile.handle, capacityKey.."#fillType") == g_fillTypeManager:getFillTypeNameByIndex(input) then
                  --add inputs, we don't need to check if they already exist because why should we, no need to add new ones.. lol
                  for index, getInput in pairs(get.inputs) do
                    xmlFile:setString(key..".storage.capacity("..numberOfCapacities+index..")#fillType", g_fillTypeManager:getFillTypeNameByIndex(getInput.type))
                    xmlFile:setInt(key..".storage.capacity("..numberOfCapacities+index..")#capacity", xmlFile:getInt(capacityKey.."capacity", storageSize))
                  end
                end
              end)

              --iterate through all FillPlanes to find #
              local numberOfFillPlanes = -1
              xmlFile:iterate(key..".storage.fillPlane", function(_, _)
                numberOfFillPlanes = numberOfFillPlanes +1
              end)

              --add fillPlanes
              xmlFile:iterate(key..".storage.fillPlane", function(_, fillPlaneKey)
                if xmlFile:getString(fillPlaneKey.."#fillType") == g_fillTypeManager:getFillTypeNameByIndex(input) then
                  for index, getInput in pairs(get.inputs) do
                    setXMLString(xmlFile.handle, key..".storage.fillPlane("..numberOfFillPlanes+index..")#node", getXMLString(xmlFile.handle, fillPlaneKey.."#node"))

                    xmlFile:setString(key..".storage.fillPlane("..numberOfFillPlanes+index..")#fillType", g_fillTypeManager:getFillTypeNameByIndex(getInput.type))
                    xmlFile:setFloat(key..".storage.fillPlane("..numberOfFillPlanes+index..")#minY", xmlFile:getFloat(fillPlaneKey.."#minY"))
                    xmlFile:setFloat(key..".storage.fillPlane("..numberOfFillPlanes+index..")#maxY", xmlFile:getFloat(fillPlaneKey.."#maxY"))
                  end
                end
              end)

              --extend Unload Trigger with new FillTypes if presend
              xmlFile:iterate(key..".sellingStation.unloadTrigger", function(index,  unloadTriggerKey)
                local fillTypes = xmlFile:getString(unloadTriggerKey.."#fillTypes")
                for _, unloadFillType in pairs(g_fillTypeManager:getFillTypesByNames(fillTypes)) do
                  if unloadFillType == input then
                    local oldFillTypes = xmlFile:getString(unloadTriggerKey.."#fillTypes")
                    xmlFile:setString(unloadTriggerKey.."#fillTypes", oldFillTypes .. unloadFillTypeList)
                  end
                end
              end)

              --get number of fillTypes in <Sellingstation /> for next function
              local numberOfFillTypes = -1
              xmlFile:iterate(key..".sellingStation.fillType", function(_, _)
                numberOfFillTypes = numberOfFillTypes + 1
              end)

              --add <fillType /> entrys into sellingstation
              if numberOfFillTypes > -1 then
                xmlFile:iterate(key..".sellingStation.fillType", function(index, fillTypeKey)

                  local fillType = g_fillTypeManager:getFillTypeIndexByName(xmlFile:getValue(fillTypeKey .. "#name"))
                  if fillType == input then
                    local unloadFillTypes = string.split(unloadFillTypeList, " ")
                    for i = 1, #unloadFillTypes do
                      local unloadFillType = g_fillTypeManager:getFillTypeIndexByName(unloadFillTypes[i])

                      xmlFile:setString(key..".fillType("..numberOfFillTypes+i..")#name", unloadFillType.fillType)
                      xmlFile:setFloat(key..".fillType("..numberOfFillTypes+i..")#priceScale", 1)
                      xmlFile:setBool(key..".fillType("..numberOfFillTypes+i..")#supportsGreatDemand", false)
                      xmlFile:setBool(key..".fillType("..numberOfFillTypes+i..")#disablePriceDrop", false)

                    end
                  end
                end)
              end
              --set attached on true, no need to attach multiple times for multiple productionLines for the same fillType
              attached[input] = true
              --set number of production higher, to prevent accidental overwrites
              numberOfProductions = numberOfProductions + 1
            end
          end
        end
      end
    end)
  end)

  local returnValue = superFunc(self, components, xmlFile, key, customEnv, i3dMappings)

  return returnValue
end
ProductionPoint.load = Utils.overwrittenFunction(ProductionPoint.load, addToProductionAndSellingStation.load)


function addToProductionAndSellingStation.addSellingStation(self, superFunc, components, xmlFile, key, customEnv, i3dMappings, rootNode)
  local ref = addToProductionAndSellingStation
  
  --don't run this for productions, greenhouses and others, only for normal sellingssations
  if key=="placeable.sellingStation" then
    xmlFile:iterate(key..".unloadTrigger", function(index,  unloadTriggerKey)
      local fillTypes = xmlFile:getString(unloadTriggerKey.."#fillTypes") 

      for _, fillType in pairs(g_fillTypeManager:getFillTypesByNames(fillTypes)) do
        if ref.sellingStationsIndicesByAttachTo[fillType] ~= nil then
          for i = 1, #ref.sellingStationsIndicesByAttachTo[fillType] do
            local get = ref.sellingStations[ref.sellingStationsIndicesByAttachTo[fillType][i]]
            local fillTypesNew = xmlFile:getString(unloadTriggerKey.."#fillTypes") 
            xmlFile:setString(unloadTriggerKey.."#fillTypes", fillTypesNew.." "..get.fillType)
          end
        end
      end
    end)

    local numberOfFillTypes = -1
    xmlFile:iterate(key..".fillType", function(_, _)
      numberOfFillTypes = numberOfFillTypes + 1
    end)

    xmlFile:iterate(key..".fillType", function(index, fillTypeKey)
      local fillType = g_fillTypeManager:getFillTypeIndexByName(xmlFile:getValue(fillTypeKey .. "#name"))
      if ref.sellingStationsIndicesByAttachTo[fillType] ~= nil then
        for i = 1, #ref.sellingStationsIndicesByAttachTo[fillType] do
          local get = ref.sellingStations[ref.sellingStationsIndicesByAttachTo[fillType][i]]

          xmlFile:setString(key..".fillType("..numberOfFillTypes+i..")#name", get.fillType)
          xmlFile:setFloat(key..".fillType("..numberOfFillTypes+i..")#priceScale", get.priceScale)
          xmlFile:setBool(key..".fillType("..numberOfFillTypes+i..")#supportsGreatDemand", get.supportsGreatDemand)
          xmlFile:setBool(key..".fillType("..numberOfFillTypes+i..")#disablePriceDrop", get.disablePriceDrop)

        end
      end

    end)
  end

  local returnValues = superFunc(self, components, xmlFile, key, customEnv, i3dMappings, rootNode)

  return returnValues
end
SellingStation.load = Utils.overwrittenFunction(SellingStation.load, addToProductionAndSellingStation.addSellingStation)

--PnH Kompabilität mit GrassSilage und MaisSilage
function addToProductionAndSellingStation.addUnloadingStationPnH(self, superFunc, components, xmlFile, key, customEnv, i3dMappings, rootNode)
  local pnh = xmlFile:getValue("placeable#type", nil)
  --Nur für SiloBunker von PnH ausführen
  if pnh == "sandBoxSiloBunker" then
    --Ursprüngliche FillTypes laden und um neue erweitern
    local fillTypes = xmlFile:getString(key..".unloadTrigger#fillTypes") 
    fillTypes = fillTypes.. " GRASS_FERMENTED CHOPPEDMAIZE_FERMENTED"
    xmlFile:setString(key..".unloadTrigger#fillTypes", fillTypes)

    --FillTypeConverter für MaisSilage und GrassSilage eintragen
    xmlFile:setString(key..".unloadTrigger.fillTypeConversion(0)#incomingFillType", "GRASS_FERMENTED")
    xmlFile:setString(key..".unloadTrigger.fillTypeConversion(0)#outgoingFillType", "SILAGE")
    xmlFile:setFloat(key..".unloadTrigger.fillTypeConversion(0)#ratio", 0.98)
    xmlFile:setString(key..".unloadTrigger.fillTypeConversion(1)#incomingFillType", "CHOPPEDMAIZE_FERMENTED")
    xmlFile:setString(key..".unloadTrigger.fillTypeConversion(1)#outgoingFillType", "SILAGE")
    xmlFile:setFloat(key..".unloadTrigger.fillTypeConversion(1)#ratio", 1.02)
  end

  local returnValues = superFunc(self, components, xmlFile, key, customEnv, i3dMappings, rootNode)

  return returnValues
end
UnloadingStation.load = Utils.overwrittenFunction(UnloadingStation.load, addToProductionAndSellingStation.addUnloadingStationPnH)