-- This replaces FillType.SILAGE with FillType.GRASS_FERMENTED within the active missions on each sellingStation as soon as addFillLevelFromTool is called, meaning as soon as something is trying to sell.
-- While not the most elegant this seems the easiest to make Silage missions work. Also there is no reason why a bale shouldn't be GRASS_FERMENTED with MaizePlus installed in an active grass mission so.. this shouldn't cause any issues.

baleMissionGrassFermented = {}

function baleMissionGrassFermented.addFillLevelFromTool(self, superFunc, farmId, deltaFillLevel, fillType, fillInfo, toolType, extraAttributes)

	-- cycle through all missions attached to sellingStation and change fillType SILAGE to GRASS_FERMENTED
	for _, mission in pairs(self.missions) do
		if mission.fillType == FillType.SILAGE then
			mission.fillType = Utils.getNoNil(FillType.GRASS_FERMENTED, mission.fillType)		
		end
	end	
	
	-- call original func 
	return superFunc(self, farmId, deltaFillLevel, fillType, fillInfo, toolType, extraAttributes)
end
SellingStation.addFillLevelFromTool = Utils.overwrittenFunction(SellingStation.addFillLevelFromTool, baleMissionGrassFermented.addFillLevelFromTool)


