-- Override for fruitTypeConverter 
-- adding new converters via XML file 
-- also the ability to add fruitTypes to categories 

-- by modelleicher (Farming Agency)

converterOverride = {}

local modDirectory = g_currentModDirectory

-- add XML Schema
g_xmlManager:addCreateSchemaFunction(function ()
	converterOverride.xmlSchema = XMLSchema.new("converterOverride")
end)


function converterOverride.loadFruitTypes(self, superFunc, xmlFile, var1, var2)
    

    local returnValue = superFunc(self, xmlFile, var1, var2)


	-- default path within M+
	local path = modDirectory.."xml/maizePlus_converterOverride.xml"
	
    if fileExists(path) then

        local schema = converterOverride.xmlSchema
        local basePath = "converterOverride.fruitTypeConverters"

        schema:register(XMLValueType.STRING, basePath .. ".fruitTypeConverter(?)#name", "Name of FruitType Converter to be added or overwritten", nil)   
        schema:register(XMLValueType.STRING, basePath .. ".fruitTypeConverter(?).converter(?)#from", "Convert From", nil)   
        schema:register(XMLValueType.STRING, basePath .. ".fruitTypeConverter(?).converter(?)#to", "Convert To", nil)  
        schema:register(XMLValueType.STRING, basePath .. ".fruitTypeConverter(?).converter(?)#factor", "Conversion Factor", 1.0)  
        schema:register(XMLValueType.STRING, basePath .. ".fruitTypeConverter(?).converter(?)#windrowFactor", "Conversion Factor Windrow", 1.0)  
		

        local basePath1 = "converterOverride.fruitTypeCategories"	
		schema:register(XMLValueType.STRING, basePath1 .. ".fruitTypeCategory(?)#name", "Name of FruitType Category to add to", nil)  
			
			
        local xml = XMLFile.load("converterOverride", path , converterOverride.xmlSchema)
		
		
		local ftCategoryIndex = 0
		while true do
		
			local path = basePath1..".fruitTypeCategory("..ftCategoryIndex..")"
			local name = xml:getValue(path.."#name")
            if name == nil or name == "" then
                break
            end
			
			local categorieIndex = self.categories[name]
			
			local fruitTypes = getXMLString(xml.handle, path)
			
			local fruitTypeStrings = fruitTypes:split(" ")
			
			for _, fruitType in pairs (fruitTypeStrings) do
				local fruitTypeDesc = g_fruitTypeManager:getFruitTypeByName(fruitType)
			
				self:addFruitTypeToCategory(fruitTypeDesc.index, categorieIndex)
				
			end
		
			ftCategoryIndex = ftCategoryIndex + 1
		end		
		

        -- cycle trough converters
        local ftConverterIndex = 0
        while true do
            local path = basePath..".fruitTypeConverter("..ftConverterIndex..")"
            local name = xml:getValue(path.."#name")
            if name == nil or name == "" then
                break
            end
            
            -- check if converter already exists, create empty new either way
            local index = self.converterNameToIndex[name]
  

            -- if converter does not exist, add new converter 
            if index == nil then
                local converter = {}
                table.insert(self.fruitTypeConverters, converter)                
                self.converterNameToIndex[name] = #self.fruitTypeConverters
                index = #self.fruitTypeConverters
                self.nameToConverter[name] = converter

            else
                -- set or reset converter
                --self.fruitTypeConverters[index] = converter
            end
            

            -- cycle through converter entries
            local converterIndex = 0
            while true do
                local converterPath = path..".converter("..converterIndex..")"
                local from = xml:getValue(converterPath.."#from")
                local to = xml:getValue(converterPath.."#to")
                -- if from and to aren't nil go ahead
                if from ~= nil and from ~= "" and to ~= nil and to ~= "" then

                    -- convert from and to names to Index
                    local fruitType = self:getFruitTypeByName(from)
                    local fillType = g_fillTypeManager:getFillTypeByName(to)

                    -- set ftConverter values
                    self.fruitTypeConverters[index][fruitType.index] = {
                        fillTypeIndex = fillType.index,
                        conversionFactor = xml:getValue(converterPath.."#factor"),
                        windrowConversionFactor = xml:getValue(converterPath.."#windrowFactor")
                    }
                else
                    break
                end
                
                converterIndex = converterIndex + 1
            end
            

   
            ftConverterIndex = ftConverterIndex + 1
        end


    end



    return returnValue
end
FruitTypeManager.loadFruitTypes = Utils.overwrittenFunction(FruitTypeManager.loadFruitTypes, converterOverride.loadFruitTypes)