-- load animalFood from maizePlus_animalFood.xml via basegame function
-- by modelleicher (Farming Agency)

loadAnimalFood = {}

local modDirectory = g_currentModDirectory


function loadAnimalFood.loadAnimalFoodFromXML(self, superFunc, xmlFile)
	
	local returnValue = superFunc(self, xmlFile)
	
	-- default path within M+
	local path = modDirectory.."xml/maizePlus_animalFood.xml"
	
	-- check if FS22_maizePlus_animalFoodAdditions mod is present and loaded 
	local mod = g_modManager:getModByName("FS22_maizePlus_animalFoodAdditions")
	if mod ~= nil and g_modIsLoaded["FS22_maizePlus_animalFoodAdditions"] then
			
		-- check if file exists and adjust path, otherwise warning print
		if fileExists(mod.modDir.."maizePlus_animalFood.xml") then
			path = mod.modDir.."maizePlus_animalFood.xml"
		else
			print("MaizePlus Info: No maizePlus_animalFood.xml in FS22_maizePlus_animalFoodAdditions found. Default MaizePlus animalFood Settings loaded.")
		end

	end;

	-- load our custom XML or at least try to do so
	local animalFoodXml = XMLFile.load("animalFood", path, AnimalFoodSystem.xmlSchema)	
	if animalFoodXml == nil then
		print("MaizePlus Warning: Can't load maizePlus_animalFood.xml, no custom food data will be loaded! (This only happens if "..tostring(modDirectory.."xml/maizePlus_animalFood.xml").." and XML in FS22_maizePlus_animalFoodAdditions doesn't exist or can't be loaded)")
	else

		-- reset all basegame tables
		self.animalFood = {}
		self.indexToAnimalFood = {}
		self.animalTypeIndexToFood = {}
		self.mixtures = {}
		self.recipes = {}
		self.recipeFillTypeIndexToRecipe = {}
		self.animalMixtures = {}
		self.mixtureFillTypeIndexToMixture = {}

		-- load all stuff again but ours this time
		self:loadAnimalFood(animalFoodXml)
		self:loadMixtures(animalFoodXml)
		self:loadRecipes(animalFoodXml)

		-- delete xml
		animalFoodXml:delete()

	end

	return returnValue
end

AnimalFoodSystem.loadMapData = Utils.overwrittenFunction(AnimalFoodSystem.loadMapData, loadAnimalFood.loadAnimalFoodFromXML)

-- add disableSelection bool to recipes that shouldn't be selected in the mixerWagonRecipeChanger
function loadAnimalFood.loadRecipe(self, superFunc, recipe, xmlFile, key)

	local returnValues = superFunc(self, recipe, xmlFile, key)

	local disableSelection = getXMLBool(xmlFile.handle, key.."#disableSelection")
	if disableSelection then
		recipe.disableSelection = true;
	end;

	return 	returnValues
end
AnimalFoodSystem.loadRecipe = Utils.overwrittenFunction(AnimalFoodSystem.loadRecipe, loadAnimalFood.loadRecipe)


