-- Simple Display to show Mixer Wagon contents when outside of mixerwagon vehicle, shows contents, % values, possible fillTypes and fillLevel 
-- by modelleicher (Farming Agency)

mixerWagonUniversalDisplay = {}

-- default distance set to 5m for now 
mixerWagonUniversalDisplay.distance = 5
mixerWagonUniversalDisplay.isActive = true

function mixerWagonUniversalDisplay:loadMap()
    self.inputsActive = false;
    self.lastControlledVehicle = g_currentMission.controlledVehicle
end

function mixerWagonUniversalDisplay:toggleMixerDisplay()
    mixerWagonUniversalDisplay.isActive = not mixerWagonUniversalDisplay.isActive
    g_inputBinding:setActionEventText(self.eventId, g_i18n:getText("action_TOGGLE_MIXER_DISPLAY")..": "..g_i18n:getText("actionState_TOGGLE_MIXER_DISPLAY_"..tostring(mixerWagonUniversalDisplay.isActive)))
end

function mixerWagonUniversalDisplay:mixerDisplayDistance()
    mixerWagonUniversalDisplay.distance = mixerWagonUniversalDisplay.distance + 5
    if mixerWagonUniversalDisplay.distance > 70 then
        mixerWagonUniversalDisplay.distance = 5
    end
    g_inputBinding:setActionEventText(self.eventIdDistance, g_i18n:getText("action_MIXER_DISPLAY_DISTANCE")..": "..tostring(mixerWagonUniversalDisplay.distance)) 
end

function mixerWagonUniversalDisplay:draw()

    -- get distance to mixerWagons and nearest
    local nearest = mixerWagonUniversalDisplay.distance
    local nearestMixer = nil

    for _, vehicle in pairs(g_currentMission.vehicles) do
        if vehicle.spec_mixerWagon and vehicle.rootNode ~= nil then -- for some reason in MP rootNode can be nil while vehicle already exists with spec_mixerWagon so.. 
            local cameraRoot = getCamera()
            if g_currentMission.controlledVehicle then
                cameraRoot = g_currentMission.controlledVehicle.rootNode
            end
            local aX, aY, aZ = getWorldTranslation(vehicle.rootNode)
            local cX, cY, cZ = getWorldTranslation(cameraRoot);
            local dist = MathUtil.vector3Length(aX-cX, aY-cY, aZ-cZ);

            local isControlled = (vehicle == g_currentMission.controlledVehicle) or (vehicle.spec_attachable ~= nil and vehicle.spec_attachable.attacherVehicle == g_currentMission.controlledVehicle)
            if dist < mixerWagonUniversalDisplay.distance and dist <= nearest and not isControlled then
                nearest = dist
                nearestMixer = vehicle
            end
        end
    end

    -- 
    if nearestMixer ~= nil then

        if not self.inputsActive or g_currentMission.controlledVehicle ~= self.lastControlledVehicle then
            local _ , eventId = g_inputBinding:registerActionEvent(InputAction.TOGGLE_MIXER_DISPLAY, mixerWagonUniversalDisplay, mixerWagonUniversalDisplay.toggleMixerDisplay, false, true, false, true);
            g_inputBinding:setActionEventText(eventId, g_i18n:getText("action_TOGGLE_MIXER_DISPLAY")..": "..g_i18n:getText("actionState_TOGGLE_MIXER_DISPLAY_"..tostring(mixerWagonUniversalDisplay.isActive)))   
            self.eventId = eventId

            local _ , eventId = g_inputBinding:registerActionEvent(InputAction.MIXER_DISPLAY_DISTANCE, mixerWagonUniversalDisplay, mixerWagonUniversalDisplay.mixerDisplayDistance, false, true, false, true);
            g_inputBinding:setActionEventText(eventId, g_i18n:getText("action_MIXER_DISPLAY_DISTANCE")..": "..tostring(mixerWagonUniversalDisplay.distance))          
            self.eventIdDistance = eventId 
            self.inputsActive = true
        end;      


        local spec = nearestMixer.spec_mixerWagon
        -- only mixerWagons affected by M+ switcher 
        if spec.currentRecipe ~= nil and mixerWagonUniversalDisplay.isActive then

            local currentRecipe = g_currentMission.animalFoodSystem.recipes[spec.currentRecipe]

            -- number of lines needed: (number of ingredients + 1 line as header and 1 line for fillVolume total)
            local linesNeeded = #currentRecipe.ingredients +1

            local scale = 1
            
            local lowerY = 0.05
            local yPerLine = 0.019 * scale 

            -- reset text values
            setTextColor(1, 1, 1, 0.6)
            setTextBold(true)    
            
            local fillLevel = nearestMixer:getFillUnitFillLevel(spec.fillUnitIndex)
            local capacity = nearestMixer:getFillUnitCapacity(spec.fillUnitIndex)
            

            -- render header line 
            local storeItem = g_storeManager:getItemByXMLFilename(nearestMixer.configFileName)
            local headerText = g_i18n:getText("mixerDisplay_recipe").." "..g_i18n:getText("recipe_"..tostring(spec.outputFillType)).."           "..g_i18n:getText("mixerDisplay_currentFillLevel").." "..tostring(math.floor(fillLevel)).."l / "..tostring(capacity).."l      "..tostring(storeItem.name)
            setTextAlignment(RenderText.ALIGN_LEFT)
            renderText(0.25, lowerY, 0.019 * scale, headerText)

            renderText(0.25, lowerY + (yPerLine * (linesNeeded)), 0.018 * scale, g_i18n:getText("mixerDisplay_ingredient"))

            setTextAlignment(RenderText.ALIGN_RIGHT)
            renderText(0.375, lowerY + (yPerLine * (linesNeeded)), 0.018 * scale, g_i18n:getText("mixerDisplay_currentPercent"))
            renderText(0.42, lowerY + (yPerLine * (linesNeeded)), 0.018 * scale, g_i18n:getText("mixerDisplay_minPercent"))
            renderText(0.46, lowerY + (yPerLine * (linesNeeded)), 0.018 * scale, g_i18n:getText("mixerDisplay_maxPercent"))

            setTextAlignment(RenderText.ALIGN_LEFT)
            renderText(0.50, lowerY + (yPerLine * (linesNeeded)), 0.018 * scale, g_i18n:getText("mixerDisplay_fillTypes"))

            setTextBold(false)  
            -- cycle ingredients
            for index, ingredient in pairs(spec.mixerWagonFillTypes) do

                setTextAlignment(RenderText.ALIGN_LEFT)
                renderText(0.25, lowerY + (yPerLine * index), 0.017 * scale, tostring(ingredient.title))

                setTextAlignment(RenderText.ALIGN_RIGHT)
                if fillLevel > 0 then
                    renderText(0.355, lowerY + (yPerLine * index), 0.017 * scale, tostring(math.floor(ingredient.fillLevel)).."l")
                    renderText(0.39, lowerY + (yPerLine * index), 0.017 * scale, "("..tostring(math.floor((ingredient.fillLevel / fillLevel) * 100)).."%)")
                else
                    renderText(0.355, lowerY + (yPerLine * index), 0.017 * scale, "0l")
                    renderText(0.39, lowerY + (yPerLine * index), 0.017 * scale, "(0%)")
                end
                renderText(0.42, lowerY + (yPerLine * index), 0.017 * scale, tostring(ingredient.minPercentage * 100).."%")
                renderText(0.46, lowerY + (yPerLine * index), 0.017 * scale, tostring(ingredient.maxPercentage * 100).."%")

                setTextAlignment(RenderText.ALIGN_LEFT)
                local text = ""
                for fillTypeIndex, _ in pairs(ingredient.fillTypes) do
                    local title = g_fillTypeManager.indexToFillType[fillTypeIndex].title
                    text = text.." "..title.." "
                end

                renderText(0.50, lowerY + (yPerLine * index), 0.017 * scale, text)
            end
        end
    else
        self.inputsActive = false
        g_inputBinding:removeActionEvent(self.eventId)
        g_inputBinding:removeActionEvent(self.eventIdDistance)
    end

    self.lastControlledVehicle = g_currentMission.controlledVehicle
end


function mixerWagonUniversalDisplay.onPostLoad(self, superFunc, savegame)

    local returnValues = superFunc(self, savegame)

    if savegame ~= nil then
        local spec = self.spec_mixerWagon

        local displayState = getXMLBool(savegame.xmlFile.handle, savegame.key..".mixerWagon#universalDisplayState")
        if displayState ~= nil then
            mixerWagonUniversalDisplay.isActive = displayState
        end

        local distance = getXMLInt(savegame.xmlFile.handle, savegame.key..".mixerWagon#universalDisplayDistance")
        if distance ~= nil then
            mixerWagonUniversalDisplay.distance = distance
        end

    end    

    return returnValues
end
MixerWagon.onPostLoad = Utils.overwrittenFunction(MixerWagon.onPostLoad, mixerWagonUniversalDisplay.onPostLoad)


function mixerWagonUniversalDisplay.saveToXMLFile(self, superFunc, xmlFile, key, usedModNames)

    local returnValues = superFunc(self, xmlFile, key, usedModNames)

	local spec = self.spec_mixerWagon
    if mixerWagonUniversalDisplay.isActive ~= nil then
        setXMLBool(xmlFile.handle, key.."#universalDisplayState", mixerWagonUniversalDisplay.isActive)
    end
    if mixerWagonUniversalDisplay.distance ~= nil then
        setXMLInt(xmlFile.handle, key.."#universalDisplayDistance", mixerWagonUniversalDisplay.distance)
    end

    return returnValues 
end
MixerWagon.saveToXMLFile = Utils.overwrittenFunction(MixerWagon.saveToXMLFile, mixerWagonUniversalDisplay.saveToXMLFile)


addModEventListener(mixerWagonUniversalDisplay)