-- Allow to switch between conditioner and not for mowers -> converter switcher 
-- by modelleicher (Farming Agency)


mowerConverterSwitcher = {}

-- onRegister actionEvent for Mower
function mowerConverterSwitcher.onRegisterActionEvents(self, isActiveForInput, isActiveForInputIgnoreSelection)
    if self.isClient then
        local spec = self.spec_mower

        self:clearActionEventsTable(spec.actionEvents)  

        if isActiveForInputIgnoreSelection then
            local _, actionEventId = self:addActionEvent(spec.actionEvents, InputAction.IMPLEMENT_EXTRA4 , self, Mower.switchConverter, false, true, false, true, nil)
            g_inputBinding:setActionEventTextPriority(actionEventId, GS_PRIO_HIGH)
            
            g_inputBinding:setActionEventText(actionEventId, g_i18n:getText("mowerConverter_"..spec.currentConverter).." "..g_i18n:getText("action_mowerSwitchConverter"))
        end
    end
end
Mower.onRegisterActionEvents = Utils.appendedFunction(Mower.onRegisterActionEvents, mowerConverterSwitcher.onRegisterActionEvents)

function mowerConverterSwitcher.registerFunctions(vehicleType)
	SpecializationUtil.registerFunction(vehicleType, "switchConverter", Mower.switchConverter)
end
Mower.registerFunctions = Utils.appendedFunction(Mower.registerFunctions, mowerConverterSwitcher.registerFunctions)


-- append to Mower onLoad 
function mowerConverterSwitcher.onLoad(self, superFunc, savegame)
    local returnValue = superFunc(self, savegame)
    
    local spec = self.spec_mower

    -- only add mowerConditioner option to mowers with "MOWER" or "MOWERCONDITIONER" converter as default in case there is some mower-mod that does use a custom converter for whatever stuff
	local converter = self.xmlFile:getValue("vehicle.mower#fruitTypeConverter")
    if converter == "MOWER" or converter == "MOWERCONDITIONER" then
        -- list of converters for this mower, change here if this changes
        spec.converterList = {"MOWER", "MOWERCONDITIONER"} 
        -- current index 
        spec.converterIndex = 1
        -- current converter
        spec.currentConverter = spec.converterList[spec.converterIndex] 
    end

    return returnValue
end
Mower.onLoad = Utils.overwrittenFunction(Mower.onLoad, mowerConverterSwitcher.onLoad)


function Mower.switchConverter(self, actionName, inputValue, callbackState, isAnalog, value, value2, value3, noEventSend, forceIndex)

    local spec = self.spec_mower

    -- if forceIndex (from event) isn't nil set converter to that
    if forceIndex ~= nil then
        spec.currentConverter = spec.converterList[forceIndex]
    else
        -- otherwise go through list and take next, begin at 1 if at max
        for index, name in pairs(spec.converterList) do
            if name == spec.currentConverter then
                if index == #spec.converterList then
                    index = 1
                else
                    index = index +1
                end
                spec.currentConverter = spec.converterList[index]
                spec.converterIndex = index
                break
            end
        end
    end

     -- call event
    mowerConverterSwitcherEvent.sendEvent(self, spec.converterIndex, noEventSend)
   
    -- reset converter
    spec.fruitTypeConverters = {}
    local converterData = g_fruitTypeManager:getConverterDataByName(spec.currentConverter)

    if converterData ~= nil then
        for from, to in pairs(converterData) do
            spec.fruitTypeConverters[from] = to
        end
    end
	if spec.actionEvents ~= nil and spec.actionEvents[InputAction.IMPLEMENT_EXTRA4] ~= nil then
		g_inputBinding:setActionEventText(spec.actionEvents[InputAction.IMPLEMENT_EXTRA4].actionEventId, g_i18n:getText("mowerConverter_"..spec.currentConverter).." "..g_i18n:getText("action_mowerSwitchConverter"))
	end
end

-- onReadStream appendet to Mower to synch converterIndex upon joining MP game
function mowerConverterSwitcher.onReadStream(self, streamId, connection)
	local spec = self.spec_mower
    if spec.converterIndex ~= nil then
        local converterIndex = streamReadInt8(streamId)
        if converterIndex ~= nil and self.switchConverter ~= nil then
            self:switchConverter(nil, nil, nil, nil, nil, nil, nil, true, converterIndex)
        end
    end
end
Mower.onReadStream = Utils.appendedFunction(Mower.onReadStream, mowerConverterSwitcher.onReadStream)

-- onWriteStream appended to Mower to synch converterIndex upon joining MP game
function mowerConverterSwitcher.onWriteStream(self, streamId, connection)
	local spec = self.spec_mower
    if spec.converterIndex ~= nil then
	    streamWriteInt8(streamId, spec.converterIndex)
    end
end
Mower.onWriteStream = Utils.appendedFunction(Mower.onWriteStream, mowerConverterSwitcher.onWriteStream)


-- ConverterSwitch Event called when Input is called
mowerConverterSwitcherEvent = {}
local mowerConverterSwitcherEvent_mt = Class(mowerConverterSwitcherEvent, Event)

InitEventClass(mowerConverterSwitcherEvent, "mowerConverterSwitcherEvent")

function mowerConverterSwitcherEvent.emptyNew()
	local self = Event.new(mowerConverterSwitcherEvent_mt)
    self.className = "mowerConverterSwitcherEvent";
	return self
end

function mowerConverterSwitcherEvent.new(vehicle, converterIndex)
	local self = mowerConverterSwitcherEvent.emptyNew()
	self.vehicle = vehicle
	self.converterIndex = converterIndex

	return self
end

function mowerConverterSwitcherEvent:readStream(streamId, connection)
	self.vehicle = NetworkUtil.readNodeObject(streamId)
	self.converterIndex = streamReadInt8(streamId)

	self:run(connection)
end

function mowerConverterSwitcherEvent:writeStream(streamId, connection)
	NetworkUtil.writeNodeObject(streamId, self.vehicle)
	streamWriteInt8(streamId, self.converterIndex)
end

function mowerConverterSwitcherEvent:run(connection)
	if self.vehicle ~= nil and self.vehicle:getIsSynchronized() then
        self.vehicle:switchConverter(nil, nil, nil, nil, nil, nil, nil, true, self.converterIndex)
	end

	if not connection:getIsServer() then
		g_server:broadcastEvent(mowerConverterSwitcherEvent.new(self.vehicle, self.converterIndex), nil, connection, self.vehicle)
	end
end

function mowerConverterSwitcherEvent.sendEvent(vehicle, converterIndex, noEventSend)
	if (noEventSend == nil or noEventSend == false) then
		if g_server ~= nil then
			g_server:broadcastEvent(mowerConverterSwitcherEvent.new(vehicle, converterIndex), nil, nil, vehicle)
		else
			g_client:getServerConnection():sendEvent(mowerConverterSwitcherEvent.new(vehicle, converterIndex))
		end
	end
end


