
pickupCutterOverride = {}

function pickupCutterOverride.processPickupCutterArea(self, superFunc, workArea, dt)
	local spec = self.spec_cutter

	if spec.workAreaParameters.combineVehicle ~= nil then
		
	
		local sx, sy, sz = getWorldTranslation(workArea.start)
		local wx, wy, wz = getWorldTranslation(workArea.width)
		local hx, hy, hz = getWorldTranslation(workArea.height)
		local lsx, lsy, lsz, lex, ley, lez, lineRadius = DensityMapHeightUtil.getLineByAreaDimensions(sx, sy, sz, wx, wy, wz, hx, hy, hz)

		for _, fruitType in ipairs(spec.workAreaParameters.fruitTypesToUse) do
		
			-- default fillType related to this fruitType 
			local fillType = g_fruitTypeManager:getWindrowFillTypeIndexByFruitTypeIndex(fruitType)
				
			-- check if we pick up something 
			local pickedUpLiters = 0
			if fillType ~= nil then
				pickedUpLiters = pickedUpLiters + (-DensityMapHeightUtil.tipToGroundAroundLine(self, -math.huge, fillType, lsx, lsy, lsz, lex, ley, lez, lineRadius, nil, nil, false, nil))
			end
			
			local fruitTypeName = g_fruitTypeManager:getFruitTypeNameByIndex(fruitType)
		
			-- additional fillTypes related to this fruitType 
			if loadFillTypes.additionalWindrows[fruitTypeName] ~= nil then
				
				for x = 1, #loadFillTypes.additionalWindrows[fruitTypeName] do
					fillType = loadFillTypes.additionalWindrows[fruitTypeName][x]					
					if fillType ~= nil then
						pickedUpLiters = pickedUpLiters + (-DensityMapHeightUtil.tipToGroundAroundLine(self, -math.huge, fillType, lsx, lsy, lsz, lex, ley, lez, lineRadius, nil, nil, false, nil))
					end				
				end
			end
			
			
			if self.isServer and pickedUpLiters > 0 then
				local fruitDesc = g_fruitTypeManager:getFruitTypeByIndex(fruitType)
				local literPerSqm = fruitDesc.literPerSqm
				local lastCutterArea = pickedUpLiters / (g_currentMission:getFruitPixelsToSqm() * literPerSqm)

				if fruitType ~= spec.currentInputFruitType then
					spec.currentInputFruitType = fruitType
					spec.currentOutputFillType = g_fruitTypeManager:getFillTypeIndexByFruitTypeIndex(spec.currentInputFruitType)

					if spec.fruitTypeConverters[spec.currentInputFruitType] ~= nil then
						spec.currentOutputFillType = spec.fruitTypeConverters[spec.currentInputFruitType].fillTypeIndex
						spec.currentConversionFactor = spec.fruitTypeConverters[spec.currentInputFruitType].conversionFactor
					end
				end

				spec.useWindrow = true
				spec.currentInputFillType = fillType
				spec.workAreaParameters.lastFruitType = fruitType
				spec.workAreaParameters.lastRealArea = spec.workAreaParameters.lastRealArea + lastCutterArea
				spec.workAreaParameters.lastThreshedArea = spec.workAreaParameters.lastThreshedArea + lastCutterArea
				spec.workAreaParameters.lastStatsArea = spec.workAreaParameters.lastStatsArea + lastCutterArea
				spec.workAreaParameters.lastArea = spec.workAreaParameters.lastArea + lastCutterArea
				spec.stoneLastState = FSDensityMapUtil.getStoneArea(sx, sz, wx, wz, hx, hz)
				spec.isWorking = true

				break
			end		

		end
	end

	return spec.workAreaParameters.lastRealArea, spec.workAreaParameters.lastArea
end

Cutter.processPickupCutterArea = Utils.overwrittenFunction(Cutter.processPickupCutterArea, pickupCutterOverride.processPickupCutterArea)