-- Registering M+ specialiations 
-- by modelleicher (Farming Agency)


registerMaizePlusSpecs = {};

local modName = g_currentModName;
local modDirectory = g_currentModDirectory;
registerMaizePlusSpecs.modDirectory = modDirectory;
registerMaizePlusSpecs.addingDone = false

function registerMaizePlusSpecs.emptyFunctionDoNothing()

end

function registerMaizePlusSpecs:register(name)
	
	if not registerMaizePlusSpecs.addingDone then -- only run once since register added to finalizeTypes is called twice (vehicle & placeable)

		g_specializationManager:addSpecialization("mixerWagonRecipeChanger", "mixerWagonRecipeChanger", modDirectory.."scr/mixerWagonRecipeChanger.lua", nil)

		for _, vehicle in pairs(g_vehicleTypeManager:getTypes()) do
			
			local mixerWagonRecipeChanger = false;
			local mixerWagon = false;
			
			for _, spec in pairs(vehicle.specializationNames) do
				if spec == "FS22_MaizePlus.mixerWagonRecipeChanger" then 
					mixerWagonRecipeChanger = true;
				end
				if spec == "mixerWagon" then
					mixerWagon = true;
				end;			
			end    
			if not mixerWagonRecipeChanger and mixerWagon then
				g_vehicleTypeManager:addSpecialization(vehicle.name, "FS22_MaizePlus.mixerWagonRecipeChanger")
			end
		
		end
		registerMaizePlusSpecs.addingDone = true
	end
	
end
TypeManager.finalizeTypes = Utils.prependedFunction(TypeManager.finalizeTypes, registerMaizePlusSpecs.register)


addModEventListener(registerMaizePlusSpecs)