--[[
Copyright (C) GtX (Andy), 2022

Author: GtX | Andy
Date: 02.01.2022
Revision: FS22-01

Contact:
https://forum.giants-software.com
https://github.com/GtX-Andy

Important:
Not to be added to any mods / maps or modified from its current release form.
No modifications may be made to this script, including conversion to other game versions without written permission from GtX | Andy
Copying or removing any part of this code for external use without written permission from GtX | Andy is prohibited.

Darf nicht zu Mods / Maps hinzugefügt oder von der aktuellen Release-Form geändert werden.
Ohne schriftliche Genehmigung von GtX | Andy dürfen keine Änderungen an diesem Skript vorgenommen werden, einschließlich der Konvertierung in andere Spielversionen
Das Kopieren oder Entfernen irgendeines Teils dieses Codes zur externen Verwendung ohne schriftliche Genehmigung von GtX | Andy ist verboten.
]]

ObjectStorageAddBaleObjectEvent = {}

local ObjectStorageAddBaleObjectEvent_mt = Class(ObjectStorageAddBaleObjectEvent, Event)
InitEventClass(ObjectStorageAddBaleObjectEvent, "ObjectStorageAddBaleObjectEvent")

function ObjectStorageAddBaleObjectEvent.emptyNew()
    local self = Event.new(ObjectStorageAddBaleObjectEvent_mt)

    return self
end

function ObjectStorageAddBaleObjectEvent.new(object, storageAreaIndex, attributes)
    local self = ObjectStorageAddBaleObjectEvent.emptyNew()

    self.object = object
    self.storageAreaIndex = storageAreaIndex
    self.attributes = attributes

    return self
end

function ObjectStorageAddBaleObjectEvent:readStream(streamId, connection)
    self.object = NetworkUtil.readNodeObject(streamId)
    self.storageAreaIndex = streamReadUIntN(streamId, ObjectStorage.STORAGE_SEND_NUM_BITS)

    local attributes = {
        isFermenting = false,
        wrappingState = 0
    }

    attributes.fillLevel = streamReadFloat32(streamId)
    attributes.capacity = streamReadFloat32(streamId)

    if streamReadBool(streamId) then
        attributes.wrappingState = streamReadUInt8(streamId) / 255

        local r = streamReadFloat32(streamId)
        local g = streamReadFloat32(streamId)
        local b = streamReadFloat32(streamId)
        local a = streamReadFloat32(streamId)

        attributes.wrappingColor = {r, g, b, a}
    end

    if streamReadBool(streamId) then
        attributes.isFermenting = true
        attributes.fermentingPercentage = streamReadUInt8(streamId) / 255
    end

    self.attributes = attributes

    self:run(connection)
end

function ObjectStorageAddBaleObjectEvent:writeStream(streamId, connection)
    NetworkUtil.writeNodeObject(streamId, self.object)
    streamWriteUIntN(streamId, self.storageAreaIndex, ObjectStorage.STORAGE_SEND_NUM_BITS)

    local attributes = self.attributes
    local fillLevel = attributes.fillLevel or 0

    streamWriteFloat32(streamId, fillLevel)
    streamWriteFloat32(streamId, attributes.capacity or fillLevel)

    if streamWriteBool(streamId, attributes.wrappingState > 0) then
        streamWriteUInt8(streamId, MathUtil.clamp(attributes.wrappingState * 255, 0, 255))

        streamWriteFloat32(streamId, attributes.wrappingColor[1] or 1)
        streamWriteFloat32(streamId, attributes.wrappingColor[2] or 1)
        streamWriteFloat32(streamId, attributes.wrappingColor[3] or 1)
        streamWriteFloat32(streamId, attributes.wrappingColor[4] or 1)
    end

    if streamWriteBool(streamId, attributes.isFermenting) then
        streamWriteUInt8(streamId, MathUtil.clamp(attributes.fermentingPercentage * 255, 0, 255))
    end
end

function ObjectStorageAddBaleObjectEvent:run(connection)
    if connection:getIsServer() and self.object ~= nil then
        self.object:addToStorage(self.object.indexedStorageAreas[self.storageAreaIndex], self.attributes)
    end
end
