--[[
Copyright (C) GtX (Andy), 2022

Author: GtX | Andy
Date: 02.01.2022
Revision: FS22-01

Contact:
https://forum.giants-software.com
https://github.com/GtX-Andy

Important:
Not to be added to any mods / maps or modified from its current release form.
No modifications may be made to this script, including conversion to other game versions without written permission from GtX | Andy
Copying or removing any part of this code for external use without written permission from GtX | Andy is prohibited.

Darf nicht zu Mods / Maps hinzugefügt oder von der aktuellen Release-Form geändert werden.
Ohne schriftliche Genehmigung von GtX | Andy dürfen keine Änderungen an diesem Skript vorgenommen werden, einschließlich der Konvertierung in andere Spielversionen
Das Kopieren oder Entfernen irgendeines Teils dieses Codes zur externen Verwendung ohne schriftliche Genehmigung von GtX | Andy ist verboten.
]]

ObjectStorageRemoveObjectEvent = {}

local ObjectStorageRemoveObjectEvent_mt = Class(ObjectStorageRemoveObjectEvent, Event)
InitEventClass(ObjectStorageRemoveObjectEvent, "ObjectStorageRemoveObjectEvent")

function ObjectStorageRemoveObjectEvent.emptyNew()
    local self = Event.new(ObjectStorageRemoveObjectEvent_mt)

    return self
end

function ObjectStorageRemoveObjectEvent.new(object, storageAreaIndex)
    local self = ObjectStorageRemoveObjectEvent.emptyNew()

    self.object = object
    self.storageAreaIndex = storageAreaIndex

    return self
end

function ObjectStorageRemoveObjectEvent:readStream(streamId, connection)
    self.object = NetworkUtil.readNodeObject(streamId)
    self.storageAreaIndex = streamReadUIntN(streamId, ObjectStorage.STORAGE_SEND_NUM_BITS)

    self:run(connection)
end

function ObjectStorageRemoveObjectEvent:writeStream(streamId, connection)
    NetworkUtil.writeNodeObject(streamId, self.object)
    streamWriteUIntN(streamId, self.storageAreaIndex, ObjectStorage.STORAGE_SEND_NUM_BITS)
end

function ObjectStorageRemoveObjectEvent:run(connection)
    if connection:getIsServer() and self.object ~= nil then
        self.object:removeFromStorage(self.object.indexedStorageAreas[self.storageAreaIndex])
    end
end