--[[
Copyright (C) GtX (Andy), 2022

Author: GtX | Andy
Date: 02.01.2022
Revision: FS22-01

Contact:
https://forum.giants-software.com
https://github.com/GtX-Andy

Important:
Not to be added to any mods / maps or modified from its current release form.
No modifications may be made to this script, including conversion to other game versions without written permission from GtX | Andy
Copying or removing any part of this code for external use without written permission from GtX | Andy is prohibited.

Darf nicht zu Mods / Maps hinzugefügt oder von der aktuellen Release-Form geändert werden.
Ohne schriftliche Genehmigung von GtX | Andy dürfen keine Änderungen an diesem Skript vorgenommen werden, einschließlich der Konvertierung in andere Spielversionen
Das Kopieren oder Entfernen irgendeines Teils dieses Codes zur externen Verwendung ohne schriftliche Genehmigung von GtX | Andy ist verboten.
]]

ObjectStorageSetInputTriggerEvent = {}

local ObjectStorageSetInputTriggerEvent_mt = Class(ObjectStorageSetInputTriggerEvent, Event)
InitEventClass(ObjectStorageSetInputTriggerEvent, "ObjectStorageSetInputTriggerEvent")

function ObjectStorageSetInputTriggerEvent.emptyNew()
    local self = Event.new(ObjectStorageSetInputTriggerEvent_mt)

    return self
end

function ObjectStorageSetInputTriggerEvent.new(object, inputTriggerState)
    local self = ObjectStorageSetInputTriggerEvent.emptyNew()

    self.object = object
    self.inputTriggerState = inputTriggerState

    return self
end

function ObjectStorageSetInputTriggerEvent:readStream(streamId, connection)
    self.object = NetworkUtil.readNodeObject(streamId)
    self.inputTriggerState = streamReadBool(streamId)

    self:run(connection)
end

function ObjectStorageSetInputTriggerEvent:writeStream(streamId, connection)
    NetworkUtil.writeNodeObject(streamId, self.object)
    streamWriteBool(streamId, self.inputTriggerState)
end

function ObjectStorageSetInputTriggerEvent:run(connection)
    if not connection:getIsServer() then
        g_server:broadcastEvent(self, false, connection, self.object)
    end

    if self.object ~= nil then
        self.object:setInputTriggerState(self.inputTriggerState, true)

        g_messageCenter:publishDelayed("OBJECT_STORAGE_UPDATE_GUI", self.object)
    end
end

function ObjectStorageSetInputTriggerEvent.sendEvent(object, inputTriggerState, noEventSend)
    if noEventSend == nil or noEventSend == false then
        if g_server ~= nil then
            g_server:broadcastEvent(ObjectStorageSetInputTriggerEvent.new(object, inputTriggerState), nil, nil, object)
        else
            g_client:getServerConnection():sendEvent(ObjectStorageSetInputTriggerEvent.new(object, inputTriggerState))
        end
    end
end
