--[[
Copyright (C) GtX (Andy), 2022

Author: GtX | Andy
Date: 02.01.2022
Revision: FS22-01

Contact:
https://forum.giants-software.com
https://github.com/GtX-Andy

Important:
Not to be added to any mods / maps or modified from its current release form.
No modifications may be made to this script, including conversion to other game versions without written permission from GtX | Andy
Copying or removing any part of this code for external use without written permission from GtX | Andy is prohibited.

Darf nicht zu Mods / Maps hinzugefügt oder von der aktuellen Release-Form geändert werden.
Ohne schriftliche Genehmigung von GtX | Andy dürfen keine Änderungen an diesem Skript vorgenommen werden, einschließlich der Konvertierung in andere Spielversionen
Das Kopieren oder Entfernen irgendeines Teils dieses Codes zur externen Verwendung ohne schriftliche Genehmigung von GtX | Andy ist verboten.
]]

ObjectStorageSpawnObjectsEvent = {}

local ObjectStorageSpawnObjectsEvent_mt = Class(ObjectStorageSpawnObjectsEvent, Event)
InitEventClass(ObjectStorageSpawnObjectsEvent, "ObjectStorageSpawnObjectsEvent")

function ObjectStorageSpawnObjectsEvent.emptyNew()
    local self = Event.new(ObjectStorageSpawnObjectsEvent_mt)

    return self
end

function ObjectStorageSpawnObjectsEvent.new(object, storageAreaIndex, numToSpawn)
    local self = ObjectStorageSpawnObjectsEvent.emptyNew()

    self.object = object
    self.storageAreaIndex = storageAreaIndex
    self.numToSpawn = numToSpawn

    return self
end

function ObjectStorageSpawnObjectsEvent:readStream(streamId, connection)
    self.object = NetworkUtil.readNodeObject(streamId)
    self.storageAreaIndex = streamReadUIntN(streamId, ObjectStorage.STORAGE_SEND_NUM_BITS)
    self.numToSpawn = streamReadUInt8(streamId)

    self:run(connection)
end

function ObjectStorageSpawnObjectsEvent:writeStream(streamId, connection)
    NetworkUtil.writeNodeObject(streamId, self.object)
    streamWriteUIntN(streamId, self.storageAreaIndex, ObjectStorage.STORAGE_SEND_NUM_BITS)
    streamWriteUInt8(streamId, self.numToSpawn)
end

function ObjectStorageSpawnObjectsEvent:run(connection)
    if not connection:getIsServer() and self.object ~= nil then
        self.object:spawnObjects(self.storageAreaIndex, self.numToSpawn, connection)
    end
end
