--[[
Copyright (C) GtX (Andy), 2022

Author: GtX | Andy
Date: 02.01.2022
Revision: FS22-02

Contact:
https://forum.giants-software.com
https://github.com/GtX-Andy

Important:
Not to be added to any mods / maps or modified from its current release form.
No modifications may be made to this script, including conversion to other game versions without written permission from GtX | Andy
Copying or removing any part of this code for external use without written permission from GtX | Andy is prohibited.

Darf nicht zu Mods / Maps hinzugefügt oder von der aktuellen Release-Form geändert werden.
Ohne schriftliche Genehmigung von GtX | Andy dürfen keine Änderungen an diesem Skript vorgenommen werden, einschließlich der Konvertierung in andere Spielversionen
Das Kopieren oder Entfernen irgendeines Teils dieses Codes zur externen Verwendung ohne schriftliche Genehmigung von GtX | Andy ist verboten.
]]

ObjectStorageWarningMessageEvent = {}

ObjectStorageWarningMessageEvent.INVALID_FILLTYPE_MESSAGE = 0
ObjectStorageWarningMessageEvent.INVALID_SIZE_MESSAGE = 1
ObjectStorageWarningMessageEvent.NO_SPACE_MESSAGE = 2
ObjectStorageWarningMessageEvent.INVALID_FARM_MESSAGE = 3

ObjectStorageWarningMessageEvent.SEND_NUM_BITS = 3

local ObjectStorageWarningMessageEvent_mt = Class(ObjectStorageWarningMessageEvent, Event)
InitEventClass(ObjectStorageWarningMessageEvent, "ObjectStorageWarningMessageEvent")

function ObjectStorageWarningMessageEvent.emptyNew()
    local self = Event.new(ObjectStorageWarningMessageEvent_mt)

    return self
end

function ObjectStorageWarningMessageEvent.new(object, typeId, fillTypeIndex, size)
    local self = ObjectStorageWarningMessageEvent.emptyNew()

    self.object = object
    self.typeId = typeId
    self.fillTypeIndex = fillTypeIndex
    self.size = size

    return self
end

function ObjectStorageWarningMessageEvent:readStream(streamId, connection)
    self.object = NetworkUtil.readNodeObject(streamId)
    self.typeId = streamReadUIntN(streamId, ObjectStorageWarningMessageEvent.SEND_NUM_BITS)
    self.fillTypeIndex = streamReadUIntN(streamId, FillTypeManager.SEND_NUM_BITS)
    self.size = streamReadUInt16(streamId)

    self:run(connection)
end

function ObjectStorageWarningMessageEvent:writeStream(streamId, connection)
    NetworkUtil.writeNodeObject(streamId, self.object)
    streamWriteUIntN(streamId, self.typeId, ObjectStorageWarningMessageEvent.SEND_NUM_BITS)
    streamWriteUIntN(streamId, self.fillTypeIndex, FillTypeManager.SEND_NUM_BITS)
    streamWriteUInt16(streamId, math.floor(self.size or 0))
end

function ObjectStorageWarningMessageEvent:run(connection)
    if connection:getIsServer() and self.object ~= nil then
        self.object:displayWarningMessage(self.typeId, self.fillTypeIndex, self.size)
    end
end