--[[
Copyright (C) GtX (Andy), 2018

Author: GtX | Andy
Date: 14.04.2018
Revision: FS22-01

Contact:
https://forum.giants-software.com
https://github.com/GtX-Andy

Important:
Not to be added to any mods / maps or modified from its current release form.
No modifications may be made to this script, including conversion to other game versions without written permission from GtX | Andy
Copying or removing any part of this code for external use without written permission from GtX | Andy is prohibited.

Darf nicht zu Mods / Maps hinzugefügt oder von der aktuellen Release-Form geändert werden.
Ohne schriftliche Genehmigung von GtX | Andy dürfen keine Änderungen an diesem Skript vorgenommen werden, einschließlich der Konvertierung in andere Spielversionen
Das Kopieren oder Entfernen irgendeines Teils dieses Codes zur externen Verwendung ohne schriftliche Genehmigung von GtX | Andy ist verboten.
]]


CameraDialog = {}

CameraDialog.CONTROLS = {
    "dialogElement",
    "dialogHeaderElement",
    "cameraBoxElement",
    "backButton"
}
local CameraDialog_mt = Class(CameraDialog, DialogElement)

function CameraDialog.new(target, custom_mt)
    local self = DialogElement.new(target, custom_mt or CameraDialog_mt)

    self:registerControls(CameraDialog.CONTROLS)

    self.currentCamera = nil
    self.userCamera = nil
    self.overlay = 0

    return self
end

function CameraDialog:onOpen()
    if self.currentCamera ~= nil then
        self.userCamera = getCamera()
        setCamera(self.currentCamera)
    end

    CameraDialog:superClass().onOpen(self)
end

function CameraDialog:onClose()
    if self.userCamera ~= nil then
        setCamera(self.userCamera)
        self.userCamera = nil
    end

    CameraDialog:superClass().onClose(self)
end

function CameraDialog:delete()
    self:destroyCameraOverlay()

    CameraDialog:superClass().delete(self)
end

function CameraDialog:setHeaderText(text)
    self.dialogHeaderElement:setText(Utils.getNoNil(text, ""))
end

function CameraDialog:createCameraOverlay(camera)
    if self.currentCamera ~= camera or self.overlay == 0 then
        self:destroyCameraOverlay()
        -- setRenderOverlayCamera()

        self.currentCamera = camera

        if camera ~= nil then
            local resolutionX = math.ceil(g_screenWidth * self.cameraBoxElement.absSize[1]) * 2
            local resolutionY = math.ceil(g_screenHeight * self.cameraBoxElement.absSize[2]) * 2
            local aspectRatio = resolutionX / resolutionY

            local shapesMask = 255 -- show all objects with bits 1-8 enabled
            local lightMask = 134152192 -- lights I want available

            self.overlay = createRenderOverlay(camera, aspectRatio, resolutionX, resolutionY, true, shapesMask, lightMask)
        end
    end
end

function CameraDialog:destroyCameraOverlay()
    if self.overlay ~= 0 then
        delete(self.overlay)
        self.overlay = 0
    end
end

function CameraDialog:update(dt)
    CameraDialog:superClass().update(self, dt)

    if self.overlay ~= 0 then
        updateRenderOverlay(self.overlay)
    end
end

function CameraDialog:draw()
    CameraDialog:superClass().draw(self)

    if self.overlay ~= 0 then
        local posX = self.cameraBoxElement.absPosition[1]
        local posY = self.cameraBoxElement.absPosition[2]

        local sizeX = self.cameraBoxElement.size[1]
        local sizeY = self.cameraBoxElement.size[2]

        local u1, u2, u3, u4 = 0, 0, 1, 1
        local v1, v2, v3, v4 = 0, 1, 0, 1

        local clipX1, clipY1, clipX2, clipY2 = self.cameraBoxElement:getClipArea()

        if clipX1 ~= nil then
            local oldX1 = posX
            local oldY1 = posY
            local oldX2 = sizeX + posX
            local oldY2 = sizeY + posY
            local posX2 = posX + sizeX
            local posY2 = posY + sizeY

            posX = math.max(posX, clipX1)
            posY = math.max(posY, clipY1)

            sizeX = math.max(math.min(posX2, clipX2) - posX, 0)
            sizeY = math.max(math.min(posY2, clipY2) - posY, 0)

            local p1 = (posX - oldX1) / (oldX2 - oldX1)
            local p2 = (posY - oldY1) / (oldY2 - oldY1)
            local p3 = (posX + sizeX - oldX1) / (oldX2 - oldX1)
            local p4 = (posY + sizeY - oldY1) / (oldY2 - oldY1)

            u1, u2, u3, u4 = p1, p1, p3, p3
            v1, v2, v3, v4 = p2, p4, p2, p4
        end

        if u1 ~= u3 and v1 ~= v2 then
            setOverlayUVs(self.overlay, u1, v1, u2, v2, u3, v3, u4, v4)
            renderOverlay(self.overlay, posX, posY, sizeX, sizeY)
        end
    end
end
