----------------------------------------------------------------------------------------------------
-- ExtendedGroundAdjustedNodes
----------------------------------------------------------------------------------------------------
-- Purpose: loads GroundAdjustedNodes out of sprayType config.
--
-- Copyright (c) Hub3ert, 2020 / Rohne, 2021
----------------------------------------------------------------------------------------------------


---@class ExtendedGroundAdjustedNodes
ExtendedGroundAdjustedNodes = {}
ExtendedGroundAdjustedNodes.MOD_NAME = g_currentModName


function ExtendedGroundAdjustedNodes.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(GroundAdjustedNodes, specializations)
end


function ExtendedGroundAdjustedNodes.registerFunctions(vehicleType)

end


function ExtendedGroundAdjustedNodes.registerEventListeners(vehicleType)
    SpecializationUtil.registerEventListener(vehicleType, "onLoad", ExtendedGroundAdjustedNodes)
    SpecializationUtil.registerEventListener(vehicleType, "onDelete", ExtendedGroundAdjustedNodes)
	SpecializationUtil.registerEventListener(vehicleType, "onUpdate", ExtendedGroundAdjustedNodes)
end


function ExtendedGroundAdjustedNodes.registerOverwrittenFunctions(vehicleType)

end


function ExtendedGroundAdjustedNodes:onLoad(savegame)
	local spec = self.spec_groundAdjustedNodes
	local nKey = string.format("vehicle.sprayer.sprayTypes.sprayType(%d)", (self:getActiveSprayType().index-1))
    spec.groundAdjustedNodes = {}
    local i = 0
    while true do
		--loadGroundAdjustedNodeFromXML in FS22 is not working currently for custom nodes located under sprayTypes
		--thus using these only for counting, and fetching actual nodes from normal location directly under vehicle for now
        local key = string.format("vehicle.groundAdjustedNodes.groundAdjustedNode(%d)", i)
		local iKey = string.format(nKey..".groundAdjustedNodes.groundAdjustedNode(%d)", i)
        if not self.xmlFile:hasProperty(iKey) then
            break
        end

        local node = {}
        if self:loadGroundAdjustedNodeFromXML(self.xmlFile, key, node) then
            table.insert(spec.groundAdjustedNodes, node)
        end

        i = i + 1
    end

    for j=1, #spec.groundAdjustedNodes do
        local adjustedNode = spec.groundAdjustedNodes[j]
        for l=1, #adjustedNode.raycastNodes do
            local raycastNode = adjustedNode.raycastNodes[l]
            if raycastNode.updateFrame < 0 then
                raycastNode.updateFrame = #spec.groundAdjustedNodes
            end
            raycastNode.frameCount = j % raycastNode.updateFrame
        end
    end

    self.lastRaycastDistance = 0
    self.lastRaycastGroundPos = {0, 0, 0}

    if #spec.groundAdjustedNodes == 0 then
        SpecializationUtil.removeEventListener(self, "onUpdate", GroundAdjustedNodes)
    end
end



function ExtendedGroundAdjustedNodes:onDelete()

end


function ExtendedGroundAdjustedNodes:saveToXMLFile(xmlFile, key, usedModNames)

end


function ExtendedGroundAdjustedNodes:onReadStream(streamId, connection)

end


function ExtendedGroundAdjustedNodes:onWriteStream(streamId, connection)

end


function ExtendedGroundAdjustedNodes:onReadUpdateStream(streamId, timestamp, connection)

end


function ExtendedGroundAdjustedNodes:onWriteUpdateStream(streamId, connection, dirtyMask)

end


function ExtendedGroundAdjustedNodes:onUpdate(dt)

end









