local directory = g_currentModDirectory
local modName = g_currentModName

g_WorkCameraModName = modName

source(Utils.getFilename("scripts/WorkCameraMain.lua", directory))
source(Utils.getFilename("scripts/CameraElement.lua", directory))
source(Utils.getFilename("ui/WorkCameraTextInputElement.lua", directory))
source(Utils.getFilename("ui/WorkCameraGeneralSettingsFrame.lua", directory))
source(Utils.getFilename("ui/WorkCameraCameraSettingsFrame.lua", directory))
source(Utils.getFilename("ui/WorkCameraTabbedMenu.lua", directory))

local workCamera

local function isEnabled()
    return workCamera ~= nil
end

function init()
    workCamera = WorkCameraMain:new(directory, modName)

    FSBaseMission.delete = Utils.appendedFunction(FSBaseMission.delete, unload)

    Mission00.load = Utils.prependedFunction(Mission00.load, loadMission)
    Mission00.loadMission00Finished = Utils.appendedFunction(Mission00.loadMission00Finished, loadedMission)

    TypeManager.validateTypes = Utils.prependedFunction(TypeManager.validateTypes, validateVehicleTypes)

    BaseMission.onEnterVehicle = Utils.appendedFunction(BaseMission.onEnterVehicle, onEnterVehicle)
    BaseMission.onLeaveVehicle = Utils.appendedFunction(BaseMission.onLeaveVehicle, onLeaveVehicle)

    FSBaseMission.registerActionEvents =
        Utils.appendedFunction(FSBaseMission.registerActionEvents, registerActionEvents)
    BaseMission.unregisterActionEvents = Utils.appendedFunction(BaseMission.unregisterActionEvents,
        unregisterActionEvents)

    g_gui.CONFIGURATION_CLASS_MAPPING.workCameraTextInput = WorkCameraTextInputElement
end

function loadMission(mission)
    mission.workCamera = workCamera

    addModEventListener(workCamera)
end

function loadedMission(mission, node)
    if not isEnabled() then
        return
    end

    if mission.cancelLoading then
        return
    end

    workCamera:onMissionLoaded(mission)
end

function onEnterVehicle()
    workCamera:onEnterVehicle()
end

function onLeaveVehicle()
    workCamera:onLeaveVehicle()
end

function registerActionEvents()
    workCamera:registerActionEvents()
end

function unregisterActionEvents()
    workCamera:unregisterActionEvents()
end

function unload()
    if not isEnabled() then
        return
    end

    removeModEventListener(workCamera)

    workCamera:delete()
    workCamera = nil -- Allows garbage collecting

    if g_currentMission ~= nil then
        g_currentMission.workCamera = nil
    end
end

function validateVehicleTypes(typeManager)
    if typeManager.typeName == "vehicle" then
        WorkCameraMain.installSpecializations(g_vehicleTypeManager, g_specializationManager, directory, modName)
    end
end

init()
