local function getMaxHUDWidth()
    return 1920
end

local function getMaxHUDHeight()
    local aspectRatio = g_screenWidth / g_screenHeight
    return getMaxHUDWidth() / aspectRatio
end

WorkCameraGeneralSettingsFrame = {}
local WorkCameraGeneralSettingsFrame_mt = Class(WorkCameraGeneralSettingsFrame, TabbedMenuFrameElement)

WorkCameraGeneralSettingsFrame.MIN_SIZE = 100

WorkCameraGeneralSettingsFrame.CONTROLS = {"relativeCornerSetting", "positionXValue", "positionYValue", "sizeXValue",
                                           "sizeYValue", "settingsContainer", "boxLayout"}

function WorkCameraGeneralSettingsFrame.new(workCameraMain, modName)
    local self = TabbedMenuFrameElement.new(nil, WorkCameraGeneralSettingsFrame_mt)
    self:registerControls(WorkCameraGeneralSettingsFrame.CONTROLS)

    self.workCameraMain = workCameraMain
    self.modName = modName
    self.selectedItem = nil
    self.i18n = g_i18n.modEnvironments[modName]

    return self
end

function WorkCameraGeneralSettingsFrame:copyAttributes(src)
    WorkCameraGeneralSettingsFrame:superClass().copyAttributes(self, src)

    self.workCameraMain = src.workCameraMain
    self.modName = src.modName
    self.i18n = g_i18n.modEnvironments[self.modName]
end

function WorkCameraGeneralSettingsFrame:onFrameOpen()
    self.relativeCornerSetting:setTexts({self.i18n:getText("ui_WorkCamera_top_left"),
                                         self.i18n:getText("ui_WorkCamera_top_right"),
                                         self.i18n:getText("ui_WorkCamera_bottom_right"),
                                         self.i18n:getText("ui_WorkCamera_bottom_left")})

    self:updateValues()

    WorkCameraGeneralSettingsFrame:superClass().onFrameOpen(self)
end

function WorkCameraGeneralSettingsFrame:updateValues()
    local generalSettings = self.workCameraMain.generalSettings

    self.relativeCornerSetting:setState(generalSettings.relCorner)
    self.positionXValue:setText(tostring(generalSettings.position.x))
    self.positionYValue:setText(tostring(generalSettings.position.y))
    self.sizeXValue:setText(tostring(generalSettings.size.width))
    self.sizeYValue:setText(tostring(generalSettings.size.height))
end

function WorkCameraGeneralSettingsFrame:onFrameClose()
    WorkCameraGeneralSettingsFrame:superClass().onFrameClose(self)
end

function WorkCameraGeneralSettingsFrame:onSave()
    self.workCameraMain:setRelCorner(self.relativeCornerSetting:getState())
    self.workCameraMain:onUpdateGeneralSettings()
end

function WorkCameraGeneralSettingsFrame:onReset()
    self.workCameraMain:resetGeneralSettings()
    self:updateValues()
end

function WorkCameraGeneralSettingsFrame:onPositionXChanged(element)
    local x = tonumber(element:getText())

    if x == nil then
        self:onPositionXEsc(element)
        return
    end

    local margin = g_safeFrameOffsetX * getMaxHUDWidth()
    local maxX = getMaxHUDWidth() - margin * 2 - self.workCameraMain.generalSettings.size.width
    x = MathUtil.clamp(x, 0, maxX)

    self.workCameraMain.generalSettings.position.x = MathUtil.round(x)

    element:setText(tostring(self.workCameraMain.generalSettings.position.x))
end

function WorkCameraGeneralSettingsFrame:onPositionXEsc(element)
    element:setText(tostring(self.workCameraMain.generalSettings.position.x))
end

function WorkCameraGeneralSettingsFrame:onPositionYChanged(element)
    local y = tonumber(element:getText())

    if y == nil then
        self:onPositionYEsc(element)
        return
    end

    local margin = g_safeFrameOffsetY * getMaxHUDHeight()
    local maxY = getMaxHUDHeight() - margin * 2 - self.workCameraMain.generalSettings.size.height
    y = MathUtil.clamp(y, 0, maxY)

    self.workCameraMain.generalSettings.position.y = MathUtil.round(y)

    element:setText(tostring(self.workCameraMain.generalSettings.position.y))
end

function WorkCameraGeneralSettingsFrame:onPositionYEsc(element)
    element:setText(tostring(self.workCameraMain.generalSettings.position.y))
end

function WorkCameraGeneralSettingsFrame:onWidthChanged(element)
    local width = tonumber(element:getText())

    if width == nil then
        self:onWidthEsc(element)
        return
    end

    local margin = g_safeFrameOffsetX * getMaxHUDWidth()
    local maxWidthFromScreen = getMaxHUDWidth() - margin * 2
    local maxHeight = getMaxHUDHeight() - margin * 2
    local maxWidthFromHeight = self.workCameraMain:getWidthFromAspectRatio(maxHeight)
    local maxWidth = math.min(maxWidthFromScreen, maxWidthFromHeight)

    width = MathUtil.clamp(width, WorkCameraGeneralSettingsFrame.MIN_SIZE, maxWidth)

    self.workCameraMain.generalSettings.size.width = MathUtil.round(width)

    element:setText(tostring(self.workCameraMain.generalSettings.size.width))
    self:onPositionXChanged(self.positionXValue)

    if not self.workCameraMain:isValidAspectRation(self.workCameraMain.generalSettings.size.width,
        self.workCameraMain.generalSettings.size.height) then
        self.workCameraMain.generalSettings.size.height = self.workCameraMain:getHeightFromAspectRatio(
            self.workCameraMain.generalSettings.size.width)
        self.sizeYValue:setText(tostring(self.workCameraMain.generalSettings.size.height))
        self:onPositionYChanged(self.positionYValue)
    end
end

function WorkCameraGeneralSettingsFrame:onWidthEsc(element)
    element:setText(tostring(self.workCameraMain.generalSettings.size.width))
end

function WorkCameraGeneralSettingsFrame:onHeightChanged(element)
    local height = tonumber(element:getText())

    if height == nil then
        self:onHeightEsc(element)
        return
    end

    local margin = g_safeFrameOffsetY * getMaxHUDHeight()
    local maxHeightFromScreen = getMaxHUDHeight() - margin * 2
    local maxWidth = getMaxHUDWidth() - margin * 2
    local maxHeightFromWidth = self.workCameraMain:getHeightFromAspectRatio(maxWidth)
    local maxHeight = math.min(maxHeightFromScreen, maxHeightFromWidth)

    height = MathUtil.clamp(height, WorkCameraGeneralSettingsFrame.MIN_SIZE, maxHeight)

    self.workCameraMain.generalSettings.size.height = MathUtil.round(height)

    element:setText(tostring(self.workCameraMain.generalSettings.size.height))
    self:onPositionYChanged(self.positionYValue)

    if not self.workCameraMain:isValidAspectRation(self.workCameraMain.generalSettings.size.width,
        self.workCameraMain.generalSettings.size.height) then
        self.workCameraMain.generalSettings.size.width = self.workCameraMain:getWidthFromAspectRatio(self.workCameraMain
                                                                                                         .generalSettings
                                                                                                         .size.height)
        self.sizeXValue:setText(tostring(self.workCameraMain.generalSettings.size.width))
        self:onPositionXChanged(self.positionXValue)
    end
end

function WorkCameraGeneralSettingsFrame:onHeightEsc(element)
    element:setText(tostring(self.workCameraMain.generalSettings.size.height))
end

-- fix input text
function WorkCameraGeneralSettingsFrame:onTextChanged(element, text)
    element:setText(text)
end
