----------------------------------------------------------------------------
----Author: ViperGTS96------------------------------------------------------
----------------------------------------------------------------------------
--------------------"The simplest design is the best design." --------------
----------------------------------------------------------------------------

hudToggle = {}
local settingsFile = loadXMLFile("modDesc", g_currentModDirectory .. "modDesc.xml");
hudToggle.title = getXMLString(settingsFile, "modDesc.title.en");
hudToggle.author = getXMLString(settingsFile, "modDesc.author");
hudToggle.version = getXMLString(settingsFile, "modDesc.version");
delete(settingsFile);


function hudToggle:loadMap(savegame)
	hudToggle.events = {};
    Player.registerActionEvents = Utils.appendedFunction(Player.registerActionEvents, hudToggle.registerActionEvents);
	Player.removeActionEvents = Utils.appendedFunction(Player.removeActionEvents, hudToggle.removeActionEvents);
    Enterable.onRegisterActionEvents = Utils.appendedFunction(Enterable.onRegisterActionEvents, hudToggle.registerActionEvents);
	print(hudToggle.title.." : v"..hudToggle.version.." by "..hudToggle.author.." activated");
end;

function hudToggle:registerActionEvents()
	if self.isClient then
		hudToggle.events = {};
		local valid, eventId = g_inputBinding:registerActionEvent(InputAction.TOGGLEHUD, InputBinding.NO_EVENT_TARGET, hudToggle.toggleHUD, false, true, false, true);
		if valid then
			table.insert(hudToggle.events, eventId);
			g_inputBinding:setActionEventText(eventId, g_i18n:getText("input_TOGGLEHUD"));
			g_inputBinding:setActionEventTextVisibility(eventId, true);
			g_inputBinding:setActionEventTextPriority(eventId, GS_PRIO_VERYLOW);
		end;
	end;
end;

function hudToggle:removeActionEvents()
	g_inputBinding:removeActionEvent(hudToggle.events[1]);
	hudToggle.events = {};
end;

function hudToggle:toggleHUD(actionName, keyStatus, arg3, arg4, arg5)
	if actionName == "TOGGLEHUD" then		
		if g_currentMission.hud.isVisible then
			g_currentMission.hud:setIsVisible(false);
		else
			g_currentMission.hud:setIsVisible(true);
		end;
	end;
end;

addModEventListener(hudToggle);